package br.com.softilux.core.webservice;

import android.support.annotation.Nullable;

import br.com.softilux.core.utils.loading.Status;

/**
 * Created by Vinicius on 16,Abril,2019
 */
public class ApiResponseList<T> {

    public final Status status;

    @Nullable
    public final ResponseListTransfer<T> response;

    @Nullable
    public final Throwable error;

    private ApiResponseList(Status status, @Nullable ResponseListTransfer<T> response, @Nullable Throwable error) {
        this.status = status;
        this.response = response;
        this.error = error;
    }

    public static <T> ApiResponseList<T> loading() {
        return new ApiResponseList<>(Status.LOADING, null, null);
    }

    public static <T> ApiResponseList<T> success(ResponseListTransfer<T> data) {
        return new ApiResponseList<>(Status.SUCCESS, data, null);
    }

    public static <T> ApiResponseList<T> success() {
        return new ApiResponseList<>(Status.SUCCESS, null, null);
    }

    public static <T> ApiResponseList<T> error(Throwable error) {
        return new ApiResponseList<>(Status.ERROR, null, error);
    }

    public static <T> ApiResponseList<T> error() {
        return new ApiResponseList<>(Status.ERROR, null, null);
    }

    public static <T> ApiResponseList<T> errorBody(ResponseListTransfer<T> data) {
        return new ApiResponseList<>(Status.ERRORBODY, data, null);
    }

    //    private ApiResponse(Status status, @Nullable ResponseTransfer response, @Nullable Throwable error) {
//        this.status = status;
//        this.response = response;
//        this.error = error;
//    }
//
//    public static ApiResponse loading() {
//        return new ApiResponse(LOADING, null, null);
//    }
//
//    public static ApiResponse success(ResponseTransfer response) {
//        return new ApiResponse(SUCCESS, response, null);
//    }
//
//    public static ApiResponse error(@NonNull Throwable error) {
//        return new ApiResponse(ERROR, null, error);
//    }
//
//    public static ApiResponse error() {
//        return new ApiResponse(ERROR, null, null);
//    }
//
//    public static ApiResponse errorBody(ResponseTransfer response) {
//        return new ApiResponse(ERROR, response, null);
//    }
}
