package br.com.softilux.core.webservice;

import android.support.annotation.Nullable;

import br.com.softilux.core.utils.loading.ProgressLoading;
import br.com.softilux.core.utils.loading.Status;

/**
 * Created by Vinicius on 16,Abril,2019
 */
public class ApiResponse<T> extends ProgressLoading {

    @Nullable
    public final ResponseTransfer<T> response;

    private ApiResponse(Status status, @Nullable ResponseTransfer<T> response, @Nullable Throwable error) {
        super(status, error);
        this.response = response;
    }

    public static <T> ApiResponse<T> loading() {
        return new ApiResponse<>(Status.LOADING, null, null);
    }

    public static <T> ApiResponse<T> success(ResponseTransfer<T> data) {
        return new ApiResponse<>(Status.SUCCESS, data, null);
    }

    public static <T> ApiResponse<T> success() {
        return new ApiResponse<>(Status.SUCCESS, null, null);
    }

    public static <T> ApiResponse<T> error(Throwable error) {
        return new ApiResponse<>(Status.ERROR, null, error);
    }

    public static <T> ApiResponse<T> error() {
        return new ApiResponse<>(Status.ERROR, null, null);
    }

    public static <T> ApiResponse<T> errorBody(ResponseTransfer<T> data) {
        return new ApiResponse<>(Status.ERRORBODY, data, null);
    }

    //    private ApiResponse(Status status, @Nullable ResponseTransfer response, @Nullable Throwable error) {
//        this.status = status;
//        this.response = response;
//        this.error = error;
//    }
//
//    public static ApiResponse loading() {
//        return new ApiResponse(LOADING, null, null);
//    }
//
//    public static ApiResponse success(ResponseTransfer response) {
//        return new ApiResponse(SUCCESS, response, null);
//    }
//
//    public static ApiResponse error(@NonNull Throwable error) {
//        return new ApiResponse(ERROR, null, error);
//    }
//
//    public static ApiResponse error() {
//        return new ApiResponse(ERROR, null, null);
//    }
//
//    public static ApiResponse errorBody(ResponseTransfer response) {
//        return new ApiResponse(ERROR, response, null);
//    }
}
