package br.com.softilux.core.utils.loading;

import android.support.annotation.Nullable;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Created by Vinicius on 20,Maio,2019
 */
public class DatabaseResponseList<T> extends ProgressLoading {

    @Nullable
    public final List<T> response;

    public DatabaseResponseList(@NotNull Status status, @Nullable List<T> response, @Nullable Throwable error) {
        super(status, error);
        this.response = response;
    }

    public static <T> DatabaseResponseList<T> loading() {
        return new DatabaseResponseList<>(Status.LOADING, null, null);
    }

    public static <T> DatabaseResponseList<T> success(List<T> data) {
        return new DatabaseResponseList<>(Status.SUCCESS, data, null);
    }

    public static <T> DatabaseResponseList<T> success() {
        return new DatabaseResponseList<>(Status.SUCCESS, null, null);
    }

    public static <T> DatabaseResponseList<T> error(Throwable error) {
        return new DatabaseResponseList<>(Status.ERROR, null, error);
    }

    public static <T> DatabaseResponseList<T> error() {
        return new DatabaseResponseList<>(Status.ERROR, null, null);
    }

    public static <T> DatabaseResponseList<T> errorBody(List<T> data) {
        return new DatabaseResponseList<>(Status.ERRORBODY, data, null);
    }

}
