package br.com.softilux.core.utils.loading;

import android.support.annotation.Nullable;

import br.com.softilux.core.utils.LoggerUtils;

/**
 * Created by Vinicius on 20,Maio,2019
 */
public class DatabaseResponse<T> extends ProgressLoading {

    @Nullable
    public final T response;

    public DatabaseResponse(Status status, @Nullable T response, @Nullable Throwable error) {
        super(status, error);
        this.response = response;
    }

    public static <T> DatabaseResponse<T> loading() {
        return new DatabaseResponse<>(Status.LOADING, null, null);
    }

    public static <T> DatabaseResponse<T> success(T data) {
        return new DatabaseResponse<>(Status.SUCCESS, data, null);
    }

    public static <T> DatabaseResponse<T> success() {
        return new DatabaseResponse<>(Status.SUCCESS, null, null);
    }

    public static <T> DatabaseResponse<T> error(Throwable error) {
        LoggerUtils.error(error, "Deu erro", error);
        return new DatabaseResponse<>(Status.ERROR, null, error);
    }

    public static <T> DatabaseResponse<T> error() {
        return new DatabaseResponse<>(Status.ERROR, null, null);
    }

    public static <T> DatabaseResponse<T> errorBody(T data) {
        return new DatabaseResponse<>(Status.ERRORBODY, data, null);
    }

}
