package br.com.softilux.core.utils.dialogs;

import android.app.AlertDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

import org.jetbrains.annotations.NotNull;

import br.com.softilux.core.R;

public class ServerErrorDialogFragment extends DialogFragment {

    public static ServerErrorDialogFragment newInstance() {
        return new ServerErrorDialogFragment();
    }

    @NotNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(getActivity());
        alertDialogBuilder.setTitle(R.string.server_error_dialog_title);
        alertDialogBuilder.setMessage(R.string.server_error_dialog_message);
        alertDialogBuilder.setPositiveButton(
                R.string.server_error_dialog_button_caption,
                (dialog, which) -> dismiss()
        );
        return alertDialogBuilder.create();
    }
}
