package br.com.softilux.core.utils.dialogs;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;

import org.jetbrains.annotations.NotNull;

import br.com.softilux.core.R;

public class PermissaoCameraDialogFragment extends DialogFragment {

    public static PermissaoCameraDialogFragment newInstance() {
        return new PermissaoCameraDialogFragment();
    }

    @NotNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity(), R.style.AlertDialogTheme);

        builder.setTitle(getString(R.string.permissao_necessaria));
        builder.setMessage(getString(R.string.permissao_camera_fornecer));
        builder.setPositiveButton(getString(android.R.string.ok) , new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        builder.setNegativeButton(getString(android.R.string.cancel), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        AlertDialog alertDialog = builder.create();
        // Não cancela o alert se o usuario clicar fora
        alertDialog.setCanceledOnTouchOutside(false);

        return alertDialog;
    }
}
