package br.com.softilux.core.utils;

import timber.log.Timber;

public class LoggerUtils {

    public static void init(boolean isDebugMode) {
        if (isDebugMode) {
            Timber.plant(new Timber.DebugTree());
        }
    }

    public static void d(String s, Object... objects) {
        Timber.d(s, objects);
    }

    public static void d(Throwable throwable, String s, Object... objects) {
        Timber.d(throwable, s, objects);
    }

    public static void info(String s, Object... objects) {
        Timber.i(s, objects);
    }

    public static void info(Throwable throwable, String s, Object... objects) {
        Timber.i(throwable, s, objects);
    }

    public static void warning(String s, Object... objects) {
        Timber.w(s, objects);
    }

    public static void warning(Throwable throwable, String s, Object... objects) {
        Timber.w(throwable, s, objects);
    }

    public static void error(String s, Object... objects) {
        Timber.e(s, objects);
    }

    public static void error(Throwable throwable, String s, Object... objects) {
        Timber.e(throwable, s, objects);
    }

}
