package br.com.softilux.core.utils;

import android.annotation.SuppressLint;

import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * Created by Vinicius on 04,Maio,2019
 */
public class DateUtils {

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatyyyyMMddHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatyyyyMMddHHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatddMMyyyyHHmmss = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatyyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatHHmm = new SimpleDateFormat("HH:mm");

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatHHmmSS = new SimpleDateFormat("HH:mm:ss");

    @SuppressLint("SimpleDateFormat")
    public static SimpleDateFormat formatddMMyyyy = new SimpleDateFormat("dd/MM/yyyy");


    private DateUtils () {
        // This utility class is not publicly instantiable
    }

    public static Date parseData(final String data) {
        if (StringUtils.isBlank(data)) return null;

        Date dataFormatada = null;
        try {
            dataFormatada = formatyyyyMMddHHmm.parse(data);
        } catch (ParseException e) {
            LoggerUtils.error(e, "Falha conversão da data" + data);
        }

        return dataFormatada;
    }

    public static Date parseDatayyyyMMddHHmmss(final String data) {
        if (StringUtils.isBlank(data)) return null;

        Date dataFormatada = null;
        try {
            dataFormatada = formatyyyyMMddHHmmss.parse(data);
        } catch (ParseException e) {
            LoggerUtils.error(e, "Falha conversão da data" + data);
        }

        return dataFormatada;
    }

    public static String formatYyyyMMddHHmmss(Date date) {
        if (date == null) return "";

        return formatyyyyMMddHHmmss.format(date);
    }

    public static String formatarDataEnvioJson(Date date)
    {
        if (date == null) return "";

        return formatddMMyyyy.format(date);
    }

    public static String formatarDataEnvioJsonDtAtendimento(Date date)
    {
        if (date == null) return "";

        return formatyyyyMMdd.format(date);
    }

    public static String formatarHoraMinutoSegundoEnvioJson(Date date)
    {
        if (date == null) return "";

        return formatHHmmSS.format(date);
    }

    public static String formatarHoraMinutoEnvioJson(Date date)
    {
        if (date == null) return "";

        return formatHHmm.format(date);
    }

    /**
     * Get a diff between two dates
     * @param date1 the oldest date
     * @param date2 the newest date
     * @param timeUnit the unit in which you want the diff
     * @return the diff value, in the provided unit
     */
    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static String formatarDataHoraEnvioJson(Date date)
    {
        if (date == null) return "";

        return formatddMMyyyyHHmmss.format(date);
    }

    /**
     * Retorna nova data baseada no dia 'dt' e hora = 23:59:59
     * @param dt
     * @return Date
     */
    public static Date getDataComo23_59_59(Date dt) {
        if (dt != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dt);
            cal.set(Calendar.HOUR_OF_DAY, 23);
            cal.set(Calendar.MINUTE, 59);
            cal.set(Calendar.SECOND, 59);
            cal.set(Calendar.MILLISECOND, 999);
            return cal.getTime();
        } else
            return null;
    }

    /**
     * Retorna nova data baseada no dia 'dt' e hora = 00:00:00
     * @param dt
     * @return Date
     */
    public static Date getDataComo00_00_00(Date dt) {
        if (dt != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dt);
            cal.set(Calendar.HOUR_OF_DAY, 00);
            cal.set(Calendar.MINUTE, 00);
            cal.set(Calendar.SECOND, 00);
            cal.set(Calendar.MILLISECOND, 000);
            return cal.getTime();
        } else
            return null;
    }

    public static Date getDate(long timemillis) {
        Date date = Calendar.getInstance().getTime();
        date.setTime(timemillis);
        return date;
    }



}
