package br.com.softilux.core.entities;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import org.jetbrains.annotations.NotNull;

@Entity(tableName = "configurations", indices = {@Index(name = "id_index_chave", value = "chave")})
public class Config {

    @PrimaryKey()
    @NonNull
    @ColumnInfo(name = "chave")
    private String chave;

    @ColumnInfo(name = "valor")
    private String valor;

    public Config(@NonNull String chave, String valor) {
        this.chave = chave;
        this.valor = valor;
    }

    public Config() { }

    @NotNull
    public String getChave() {
        return chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public String getValor() {
        return valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }
}
