package br.com.softilux.core.dao;

import android.arch.persistence.db.SimpleSQLiteQuery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import br.com.softilux.core.base.SoftiluxExpection;

public class QueryBuilder {

	private StringBuilder hqlSelect = new StringBuilder();

	private StringBuilder hqlCountSelect = new StringBuilder();

	private StringBuilder hql = new StringBuilder();

	private StringBuilder hqlOrder = new StringBuilder();

	private List<Object> parameters = new ArrayList<>();

	public QueryBuilder append(String hql) {
		return append(hql, true, null);
	}

	public QueryBuilder append(String hql, Object parameter) {
		return append(hql, true, parameter);
	}

//	public QueryBuilder<T> append(String hql, Boolean condition, Object parameter) {
//		hql += " ";
//
//		int beginVar = hql.indexOf(":");
//		int endVar = hql.indexOf(" ", beginVar);
//		if (endVar == -1)
//			endVar = hql.indexOf(")", beginVar);
//		if (endVar == -1)
//			throw new IllegalArgumentException("Query mal construida: " + hql);
//		if (beginVar == -1)
//			throw new IllegalArgumentException(
//					"Nenhuma variavel setada para o parametro: " + hql);
//
//		return append(hql, condition, parameter);
//	}

//	public QueryBuilder<T> append(String hql, Object parameter) {
//		return append(hql, true, parameter);
//	}
//
//	public QueryBuilder<T> append(String hql, Boolean condition) {
//		return append(hql, condition, null);
//	}
//
	public QueryBuilder append(String hql, Boolean condition, Object parameter) {
		if (condition) {
			this.hql.append(hql+" ");
			if (parameter != null)
				this.getParameters().add(parameter);
		}
		return this;
	}

	public QueryBuilder appendOrder(String hql) {
		hqlOrder.append(hql + " ");
		return this;
	}

	public QueryBuilder appendSelect(String hql) {
		hqlSelect.append(hql + " ");
		return this;
	}

	public QueryBuilder appendCountSelect(String hql) {
		hqlCountSelect.append(hql + " ");
		return this;
	}

	public QueryBuilder append(QueryBuilder qBuilder) {
		getHqlSelect().append(qBuilder.getHqlSelect());
		getHql().append(qBuilder.getHql());
		getHqlOrder().append(qBuilder.getHqlOrder());
		getParameters().addAll(qBuilder.getParameters());
		return this;
	}

	public SimpleSQLiteQuery getRawResultList() {
		StringBuilder hql = new StringBuilder();
		hql.append(getHqlSelect());
		hql.append(getHql());
		hql.append(getHqlOrder());

		SimpleSQLiteQuery simpleSQLiteQuery = new SimpleSQLiteQuery(hql.toString(), parameters.toArray());

		return simpleSQLiteQuery;
	}

	public SimpleSQLiteQuery getRawResultList(Integer maxResults) {
		StringBuilder hql = new StringBuilder();
		hql.append(getHqlSelect());
		hql.append(getHql());
		hql.append(getHqlOrder());

		SimpleSQLiteQuery simpleSQLiteQuery = new SimpleSQLiteQuery(hql.toString() + " LIMIT " + maxResults, parameters.toArray());

		return simpleSQLiteQuery;
	}


	public SimpleSQLiteQuery getSingleResult() {
		StringBuilder hql = new StringBuilder();
		hql.append(getHqlSelect());
		hql.append(getHql());
		hql.append(getHqlOrder());

		return new SimpleSQLiteQuery(hql.toString() + " LIMIT " + 1, parameters.toArray());
	}

	public SimpleSQLiteQuery getCountResult() {
		StringBuilder hql = new StringBuilder();
		hql.append(getHqlCountSelect());
		hql.append(getHql());

		return new SimpleSQLiteQuery(hql.toString(), parameters.toArray());
	}

	public StringBuilder getHqlSelect() {
		return hqlSelect;
	}

	public void setHqlSelect(StringBuilder hqlSelect) {
		this.hqlSelect = hqlSelect;
	}

	public StringBuilder getHql() {
		return hql;
	}

	public void setHql(StringBuilder hql) {
		this.hql = hql;
	}

	public StringBuilder getHqlOrder() {
		return hqlOrder;
	}

	public void setHqlOrder(StringBuilder hqlOrder) {
		this.hqlOrder = hqlOrder;
	}

	public StringBuilder getHqlCountSelect() {
		return hqlCountSelect;
	}

	public void setHqlCountSelect(StringBuilder hqlCountSelect) {
		this.hqlCountSelect = hqlCountSelect;
	}

	public List<Object> getParameters() {
		return parameters;
	}

	public void setParameters(List<Object> parameters) {
		this.parameters = parameters;
	}

	public QueryBuilder copy() {
		QueryBuilder queryBuilder = new QueryBuilder();
		queryBuilder.setHqlSelect(new StringBuilder(this.getHqlSelect()));
		queryBuilder.setHql(new StringBuilder(this.getHql()));
		queryBuilder.setParameters(new ArrayList<>(this.getParameters()));
		queryBuilder.setHqlCountSelect(new StringBuilder(this.getHqlCountSelect()));
		queryBuilder.setHqlOrder(new StringBuilder(this.getHqlOrder()));
		return queryBuilder;
	}
}
