package br.com.softilux.core.base;

import android.support.v7.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Vinicius on 21,Fevereiro,2019
 */
public abstract class BaseRecyclerViewItens<T extends AbstractBaseViewHolder<K>, K> extends RecyclerView.Adapter<T> {

    /**
     * Data from show in interface.
     *
     * */
    private List<K> mDataSet;

    public BaseRecyclerViewItens(List<K> klist) {
        setItens(klist);
    }

    /**
     *  Add new itens to recycler view
     *
     * */
    public void addNewItens(List<K> data) {
        mDataSet.clear();
        mDataSet.addAll(data);
        notifyDataSetChanged();
    }

    /**
     *  Provide performance to add a new item do recyclver view
     *
     * */
    public void addItem(K data) {
        mDataSet.add(data);
        notifyItemInserted(mDataSet.size());
    }

    /**
     *  Remove item
     *
     * */
    public void removeItem(int position) {
        mDataSet.remove(position);
        notifyItemRemoved(position);
        notifyItemRangeChanged(position, mDataSet.size());
    }

    /**
     *  Modify list itens
     *
     * */
    public void setItens(List<K> data) {
        this.mDataSet = data;
    }

    /**
     *  Get itens
     *
     * */
    public List<K> getItens() {
        if (mDataSet == null)
            mDataSet = new ArrayList<>();
        return this.mDataSet;
    }

    @Override
    public int getItemCount() {
        return mDataSet.size();
    }

}
