package br.com.softilux.softiluxapp.ui.splash;

import android.os.Handler;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.data.preferences.Preferences;
import br.com.softilux.softiluxapp.data.repository.UsuarioLogadoCache;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class SplashPresenter<V extends SplashMvpView> extends BasePresenter<V>
        implements SplashMvpPresenter<V> {

    private final Preferences mPreferences;
    private final IPaperBook mPaperBook;

    @Inject
    public SplashPresenter(DataManager dataManager,
                           Preferences preferences,
                           IPaperBook iPaperBook,
                           SchedulerProvider schedulerProvider,
                           CompositeDisposable compositeDisposable,
                           ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable, configDAO);
        this.mPreferences = preferences;
        this.mPaperBook = iPaperBook;
    }

    @Override
    public void onAttach(V mvpView) {
        super.onAttach(mvpView);
        if (isViewAttached())
            decideNextActivity();
    }

    private void decideNextActivity() {
        new Handler().postDelayed(() -> {
            DataManager.LoggedInMode isLogged = mPaperBook.getLogginMode();
            //int logginMode = mPreferences.getCurrentUserLoggedInMode();
            if (DataManager.LoggedInMode.LOGGED_IN_MODE_SERVER == isLogged) {
                getMvpView().openMainActivity();
            } else {
                getMvpView().openLoginActivity();
            }
        }, 3000);
    }

}
