package br.com.softilux.softiluxapp.ui.splash;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.login.LoginActivity;
import br.com.softilux.softiluxapp.ui.main.MainActivity3;
import butterknife.ButterKnife;

public class SplashActivity extends AbstractBaseActivity implements SplashMvpView {

    @Inject
    SplashMvpPresenter<SplashMvpView> mPresenter;

    public static Intent getStartIntent(Context context) {
        return new Intent(context, SplashActivity.class);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);
        getActivityComponent().inject(this);
        mPresenter.onAttach(this);
    }

    /**
     * Making the screen wait so that the  branding can be shown
     */
    @Override
    public void openLoginActivity() {
        Intent intent = openActivity(LoginActivity.class);
        startActivity(intent);
        finish();
    }

    @Override
    public void openMainActivity() {
        Intent intent = openActivity(MainActivity3.class);
        startActivity(intent);
        finish();
    }

    @Override
    public void startSyncService() {
//        SyncService.start(this);
    }

    @Override
    protected void onDestroy() {
        mPresenter.onDetach();
        super.onDestroy();
    }

    @Override
    protected void setUp() {
        // Não implementado
    }
}
