package br.com.softilux.softiluxapp.ui.solicitacoes;

import android.os.Parcel;
import android.os.Parcelable;

public class SolicitacaoPecaModel implements Parcelable {

    private Long id;

    private String fichaTecnica;

    private String produto;

    private int quantidade;

    private String status;

    private boolean pecaCritica;

    private boolean necessitaDevolucao;

    public SolicitacaoPecaModel(Long id, String fichaTecnica, String produto, int quantidade, String status, boolean pecaCritica, boolean necessitaDevolucao) {
        this.id = id;
        this.fichaTecnica = fichaTecnica;
        this.produto = produto;
        this.quantidade = quantidade;
        this.status = status;
        this.pecaCritica = pecaCritica;
        this.necessitaDevolucao = necessitaDevolucao;
    }

    protected SolicitacaoPecaModel(Parcel in) {
        if (in.readByte() == 0) {
            id = null;
        } else {
            id = in.readLong();
        }
        fichaTecnica = in.readString();
        produto = in.readString();
        quantidade = in.readInt();
        status = in.readString();
        pecaCritica = in.readByte() != 0;
        necessitaDevolucao = in.readByte() != 0;
    }

    public SolicitacaoPecaModel() {

    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (id == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeLong(id);
        }
        dest.writeString(fichaTecnica);
        dest.writeString(produto);
        dest.writeInt(quantidade);
        dest.writeString(status);
        dest.writeByte((byte) (pecaCritica ? 1 : 0));
        dest.writeByte((byte) (necessitaDevolucao ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SolicitacaoPecaModel> CREATOR = new Creator<SolicitacaoPecaModel>() {
        @Override
        public SolicitacaoPecaModel createFromParcel(Parcel in) {
            return new SolicitacaoPecaModel(in);
        }

        @Override
        public SolicitacaoPecaModel[] newArray(int size) {
            return new SolicitacaoPecaModel[size];
        }
    };

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFichaTecnica() {
        return fichaTecnica;
    }

    public void setFichaTecnica(String fichaTecnica) {
        this.fichaTecnica = fichaTecnica;
    }

    public String getProduto() {
        return produto;
    }

    public void setProduto(String produto) {
        this.produto = produto;
    }

    public int getQuantidade() {
        return quantidade;
    }

    public void setQuantidade(int quantidade) {
        this.quantidade = quantidade;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isPecaCritica() {
        return pecaCritica;
    }

    public void setPecaCritica(boolean pecaCritica) {
        this.pecaCritica = pecaCritica;
    }

    public boolean isNecessitaDevolucao() {
        return necessitaDevolucao;
    }

    public void setNecessitaDevolucao(boolean necessitaDevolucao) {
        this.necessitaDevolucao = necessitaDevolucao;
    }
}
