package br.com.softilux.softiluxapp.ui.solicitacoes;

import android.os.AsyncTask;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class NovaSolicitacaoPresenter<V extends NovaSolicitacaoMvpView> extends BasePresenter<V>
        implements NovaSolicitacaoMvpPresenter<V> {

    @Inject
    public NovaSolicitacaoPresenter(DataManager dataManager,
                           SchedulerProvider schedulerProvider,
                           CompositeDisposable compositeDisposable,
                                    ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable, configDAO);
    }

    @Override
    public void onClickSolicitarNovaPeca() {
        getMvpView().hideKeyboard();
        getMvpView().showLoading();

        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            protected void onPostExecute(Void aVoid) {
                super.onPostExecute(aVoid);
                getMvpView().hideLoading();
                getMvpView().finishThisActivity();
            }
        }.execute();

    }
}
