package br.com.softilux.softiluxapp.ui.solicitacoes;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import org.apache.commons.lang3.StringUtils;

import java.util.List;

import br.com.softilux.softiluxapp.R;

/**
 * Created by Vinicius on 05,Fevereiro,2019
 */
public class NovaSolicitacaoAdapter extends RecyclerView.Adapter<NovaSolicitacaoAdapter.NovaSolicitacaoViewHolder> {

    private Context mContext;
    private List<SolicitacaoPecaModel> mDataSet;
    private SolicitacaoClickListener mListener;

    public NovaSolicitacaoAdapter(final Context context,
                                  List<SolicitacaoPecaModel> pecas,
                                  final SolicitacaoClickListener solicitacaoClickListener) {

        mContext = context;
        mDataSet = pecas;
        mListener = solicitacaoClickListener;
    }

    @NonNull
    @Override
    public NovaSolicitacaoViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View inflate = LayoutInflater.from(mContext).inflate(R.layout.peca_item_row, viewGroup, false);
        return new NovaSolicitacaoViewHolder(inflate);
    }

    @Override
    public void onBindViewHolder(@NonNull NovaSolicitacaoViewHolder novaSolicitacaoViewHolder, int position) {
        novaSolicitacaoViewHolder.bind(mDataSet.get(position));
    }

    @Override
    public int getItemCount() {
        return mDataSet.size();
    }

    public class NovaSolicitacaoViewHolder extends RecyclerView.ViewHolder {
        TextView nomePeca;
        TextView nomePecaLabel;
        TextView quantidadePeca;
        TextView quantidadePecaLabel;

        public NovaSolicitacaoViewHolder(@NonNull View itemView) {
            super(itemView);
            nomePeca = itemView.findViewById(R.id.tv_nome_peca);
            nomePecaLabel = itemView.findViewById(R.id.tv_nome_peca_label);
            quantidadePeca  = itemView.findViewById(R.id.tv_quantidade_solicitada);
            quantidadePecaLabel = itemView.findViewById(R.id.tv_quantidade_solicitada_label);
        }

        public void bind(SolicitacaoPecaModel solicitacaoPecaModel) {
            String builder = "Peça solicitada " +solicitacaoPecaModel.getId() + " - ";
            nomePecaLabel.setText(builder);

            if (StringUtils.isNotBlank(solicitacaoPecaModel.getFichaTecnica()))
                nomePeca.setText(solicitacaoPecaModel.getFichaTecnica());
            else
                nomePeca.setText(solicitacaoPecaModel.getProduto());

            quantidadePeca.setText(String.valueOf(solicitacaoPecaModel.getQuantidade()));
        }

    }

}
