package br.com.softilux.softiluxapp.ui.solicitacoes;

import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.ActivityNovaSolicitacaoBinding;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.softiluxapp.ui.chamado.CurrentChamado;

/**
 * Created by Vinicius on 05,Fevereiro,2019
 */
public class NovaSolicitacaoActivity extends AbstractBaseActivity implements NovaSolicitacaoMvpView {

    @Inject
    NovaSolicitacaoMvpPresenter<NovaSolicitacaoMvpView> mPresenter;

    ActivityNovaSolicitacaoBinding binding;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_nova_solicitacao);
        getActivityComponent().inject(this);
        mPresenter.onAttach(this);
        setUp();
    }

    public static Intent getStartIntent(Context context) {
        return new Intent(context, NovaSolicitacaoActivity.class);
    }

    @Override
    protected void setUp() {
        setSupportActionBar(binding.toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }

        ArrayAdapter<String> stringArrayAdapter = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, getResources().getStringArray(R.array.fichas_tecnicas));
        binding.spnFichaTecnica.setAdapter(stringArrayAdapter);

        ArrayAdapter<String> stringArrayAdapter2 = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, getResources().getStringArray(R.array.status_peca));
        binding.spnStatusPeca.setAdapter(stringArrayAdapter2);

        binding.btnSolicitar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mPresenter.onClickSolicitarNovaPeca();
            }
        });
    }

    @Override
    public void finishThisActivity() {
        //ChamadosStatic currentChamado = CurrentChamado.getInstance().getCurrentChamado();
        AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();
        SolicitacaoPecaModel mSolicitacaoPecaModel = gerarNovaPeca(currentAtendimentoChamado);
        currentAtendimentoChamado.getPecasSolicitadas().add(mSolicitacaoPecaModel);
        CurrentChamado.getInstance().getCurrentChamado().updateAtendimento(currentAtendimentoChamado);
        finish();
    }

    private SolicitacaoPecaModel gerarNovaPeca(AtendimentoChamado atendimentoChamado) {
        SolicitacaoPecaModel solicitacaoPecaModel = new SolicitacaoPecaModel();
        String fichaTecnica = (String) binding.spnFichaTecnica.getSelectedItem();
        String statusPeca = (String) binding.spnStatusPeca.getSelectedItem();
        boolean necessitaDevolucao = binding.cbNecessitaDevolucao.isChecked();
        boolean pecaCritica = binding.cbPecaCritica.isChecked();
        int quantidadePeca = 0;
        String nomeProduto = null;
        if (!TextUtils.isEmpty(binding.tvQuantidadePeca.getText()))
            quantidadePeca = Integer.valueOf(binding.tvQuantidadePeca.getText().toString());
        if (!TextUtils.isEmpty(binding.tvNomeProduto.getText()))
            nomeProduto = binding.tvNomeProduto.getText().toString();

        solicitacaoPecaModel.setId(Long.valueOf(atendimentoChamado.getPecasSolicitadas().size() + 1));
        solicitacaoPecaModel.setNecessitaDevolucao(necessitaDevolucao);
        solicitacaoPecaModel.setPecaCritica(pecaCritica);
        solicitacaoPecaModel.setStatus(statusPeca);
        solicitacaoPecaModel.setProduto(nomeProduto);
        solicitacaoPecaModel.setFichaTecnica(fichaTecnica);
        solicitacaoPecaModel.setQuantidade(quantidadePeca);

        return solicitacaoPecaModel;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                finish();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    protected void onDestroy() {
        mPresenter.onDetach();
        super.onDestroy();
    }
}
