package br.com.softilux.softiluxapp.ui.permissao

import android.Manifest
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Bundle
import android.support.v4.app.ActivityCompat
import android.support.v4.content.ContextCompat
import br.com.softilux.softiluxapp.R
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity
import br.com.softilux.softiluxapp.ui.main.MainActivity3
import javax.inject.Inject


/**
 * Created by Vinicius on 30,Outubro,2018
 */
class PermissaoActivity : AbstractBaseActivity(), PermissaoMvpView {

    val MY_PERMISSIONS_REQUEST_LOCATION = 99

    @Inject
    lateinit var mPresenter: PermissaoMvpPresenter<PermissaoMvpView>

    companion object {
        @JvmStatic
        fun getStartIntent(context: Context): Intent {
            return Intent(context, PermissaoActivity::class.java)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_permissao)
        activityComponent.inject(this)
        mPresenter.onAttach(this)
        setUp()
    }

    override fun setUp() {
        if (checkLocationPermission())
            mPresenter.onPermissionGranted()
    }

    private fun checkLocationPermission(): Boolean {
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {

            // Should we show an explanation?
            ActivityCompat.requestPermissions(this,
                    arrayOf(Manifest.permission.ACCESS_FINE_LOCATION),
                    MY_PERMISSIONS_REQUEST_LOCATION)
            return false
        } else {
            return true
        }
    }

    override fun onRequestPermissionsResult(requestCode: Int,
                                            permissions: Array<String>, grantResults: IntArray) {
        when (requestCode) {
            MY_PERMISSIONS_REQUEST_LOCATION -> {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    // permission was granted, yay! Do the
                    // location-related task you need to do.
                    if (ContextCompat.checkSelfPermission(this,
                                    Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {

                        mPresenter.onPermissionGranted()
                    }

                } else {

                    // permission denied, boo! Disable the
                    // functionality that depends on this permission.

                }
                return
            }
        }
    }

    override fun openMainActivity() {
        val startIntent = MainActivity3.getStartIntent(this@PermissaoActivity)
        startActivity(startIntent)
        finish()
    }

}