/*
 * Copyright (C) 2017 MINDORKS NEXTGEN PRIVATE LIMITED
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://mindorks.com/license/apache-v2
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package br.com.softilux.softiluxapp.ui.main;

import android.graphics.Color;
import android.widget.Button;
import android.widget.TextView;

import com.androidnetworking.widget.ANImageView;
import com.mindorks.placeholderview.annotations.Click;
import com.mindorks.placeholderview.annotations.Layout;
import com.mindorks.placeholderview.annotations.NonReusable;
import com.mindorks.placeholderview.annotations.Resolve;
import com.mindorks.placeholderview.annotations.View;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.Option;
import br.com.softilux.softiluxapp.data.db.model.Question;

@NonReusable
@Layout(R.layout.card_layout)
public class QuestionCard {

    private static final String TAG = "QuestionCard";

    @View(R.id.tv_question_txt)
    private TextView mQuestionTextView;

    @View(R.id.btn_option_1)
    private Button mOption1Button;

    @View(R.id.btn_option_2)
    private Button mOption2Button;

    @View(R.id.btn_option_3)
    private Button mOption3Button;

    @View(R.id.iv_pic)
    private ANImageView mPicImageView;

    private Question mQuestion;

    public QuestionCard(Question question) {
        mQuestion = question;
    }

    @Resolve
    private void onResolved() {

        mQuestionTextView.setText(mQuestion.getQuestionText());

        for (int i = 0; i < 3; i++) {
            Button button = null;
            switch (i) {
                case 0:
                    button = mOption1Button;
                    break;
                case 1:
                    button = mOption2Button;
                    break;
                case 2:
                    button = mOption3Button;
                    break;
            }

            if (button != null)
                //button.setText(mQuestion.getOptionList().get(info).getOptionText());

            if (mQuestion.getImgUrl() != null) {
                mPicImageView.setImageUrl(mQuestion.getImgUrl());
            }
        }
    }

    private void showCorrectOptions() {
        for (int i = 0; i < 3; i++) {
            //Option option = mQuestion.getOptionList().get(info);
            Button button = null;
            switch (i) {
                case 0:
                    button = mOption1Button;
                    break;
                case 1:
                    button = mOption2Button;
                    break;
                case 2:
                    button = mOption3Button;
                    break;
            }
            if (button != null) {
//                if (option.isCorrect()) {
//                    button.setBackgroundColor(Color.GREEN);
//                } else {
//                    button.setBackgroundColor(Color.RED);
//                }
            }
        }
    }

    @Click(R.id.btn_option_1)
    public void onOption1Click() {
        showCorrectOptions();
    }

    @Click(R.id.btn_option_2)
    public void onOption2Click() {
        showCorrectOptions();
    }

    @Click(R.id.btn_option_3)
    public void onOption3Click() {
        showCorrectOptions();
    }
}
