package br.com.softilux.softiluxapp.ui.main;

import android.Manifest;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.databinding.DataBindingUtil;
import android.location.Address;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

import com.blankj.utilcode.util.TimeUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.DexterError;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.PermissionRequestErrorListener;
import com.karumi.dexter.listener.single.PermissionListener;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import br.com.softilux.core.ui.decoration.StickHeaderItemDecoration;
import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.utils.constants.AppConstants;
import br.com.softilux.core.utils.loading.DatabaseResponseList;
import br.com.softilux.core.webservice.ApiResponseList;
import br.com.softilux.core.webservice.ResponseTransfer;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.dao.AtendimentoDAO;
import br.com.softilux.softiluxapp.data.dao.ChamadoDAO;
import br.com.softilux.softiluxapp.data.dao.TimelineDAO;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoFilterModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.LocationCapture;
import br.com.softilux.softiluxapp.data.db.model.Question;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.data.db.model.TipoInclusaoTimeLine;
import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.data.repository.AtendimentoRepository;
import br.com.softilux.softiluxapp.databinding.ActivityMainBinding;
import br.com.softilux.softiluxapp.di.presentation.ViewModelFactory;
import br.com.softilux.softiluxapp.service.LocationMonitoringService;
import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoFilter;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoResponse;
import br.com.softilux.softiluxapp.transfer.datatransfer.statuschamado.VerificarStatusChamadoDTO;
import br.com.softilux.softiluxapp.transfer.services.IChamadoService;
import br.com.softilux.softiluxapp.transfer.services.ITimelineService;
import br.com.softilux.softiluxapp.transfer.services.TimelineRequestResponse;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoItemRow;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoActivityJava;
import br.com.softilux.softiluxapp.ui.chamado.CurrentChamado;
import br.com.softilux.softiluxapp.ui.filter.chamado.ChamadoFilterActivity;
import br.com.softilux.softiluxapp.ui.login.LoginActivity;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import es.dmoral.toasty.Toasty;
import io.reactivex.disposables.CompositeDisposable;

/**
 * Created by Vinicius on 29,Janeiro,2019
 */
public class MainActivity3 extends AbstractBaseActivity implements MainMvpView, ChamadoItemClickListener2 {

    /**
     *  Presentation MVP
     * */
    @Inject
    MainMvpPresenter<MainMvpView> mPresenter;

    /**
     *  Factory to load view model
     * */
    @Inject
    ViewModelFactory viewModelFactory;

    /**
     *  Binding view to Class
     * */
    ActivityMainBinding binding;

    private final int CODE_FILTER_CHAMADO = 100;

    /*
    * Filtro para chamados
    * */
    private ChamadoFilterModel chamadoFilter;

    /*
     * View model que observa esta atividade
     * */
    private ChamadoViewModel mChamadoViewModel;

    /**
     * Adapter dos chamados exibidos na ui
     * */
    private ChamadosAdapter mChamadosAdapter;

    private boolean mAlreadyStartedService = false;

    @Inject
    ITimelineService iTimelineService;

    @Inject
    SchedulerProvider schedulerProvider;

    @Inject
    AtendimentoRepository atendimentoRepository;

    @Inject
    CompositeDisposable compositeDisposable;

    @Inject
    TimelineDAO mTimelineDAO;

    @Inject
    AtendimentoDAO mAtendimentoDAO;

    @Inject
    IChamadoService chamadoService;

    @Inject
    ChamadoDAO mChamadoDAO;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_main);
        getActivityComponent().inject(this);
        mPresenter.onAttach(this);
        mChamadoViewModel = ViewModelProviders.of(this, viewModelFactory).get(ChamadoViewModel.class);
        registerObservers();
        setUp();

        LocalBroadcastManager.getInstance(this).registerReceiver(
                new BroadcastReceiver() {
                    @Override
                    public void onReceive(Context context, Intent intent) {
                        String latitude = intent.getStringExtra(LocationMonitoringService.EXTRA_LATITUDE);
                        String longitude = intent.getStringExtra(LocationMonitoringService.EXTRA_LONGITUDE);

                        if (StringUtils.isNotBlank(latitude) && StringUtils.isNotBlank(longitude)
                                && getCurrentChamadoAtendimento() != null) {
                            AtendimentoModel atendimentoModel = getCurrentChamadoAtendimento().getAtendimentoModel();
                            Address address = getAddress(MainActivity3.this, Double.valueOf(latitude), Double.valueOf(longitude));
                            LoggerUtils.info("MainActivity3 " + latitude + longitude);

                            CadastrarNovaTimelineNetworkingRequest request = new CadastrarNovaTimelineNetworkingRequest();
                            // ------------------------------ Preencher dados da nova timeline
                            request.setCreateAt(DateUtils.formatYyyyMMddHHmmss(TimeUtils.getNowDate()));
                            request.setTipoTimeLine(TipoInclusaoTimeLine.INCLUSAO_SERVICO_ASSINCRONO);
                            request.setAndamentoSnapshot(null);
                            request.setMotivo(null);
                            request.setMotivoOutros(null);
                            request.setIdTecnico(atendimentoModel.getNomeAtendente());
                            request.setIdAtendimentoPortal(atendimentoModel.getIdAtendimentoPortal());
                            request.setIdBase(atendimentoModel.getIdBase());

                            // ------------------------------ Preencher localizacao
                            LocationCapture locationCapture = new LocationCapture(address);
                            LoggerUtils.info(locationCapture.toString());
                            request.setAddress(locationCapture.getAddress());
                            request.setCountryName(locationCapture.getCountryName());
                            request.setLatitute(locationCapture.getLatitute());
                            request.setLongitute(locationCapture.getLongitute());
                            request.setLocality(locationCapture.getLocality());
                            request.setLocationCaptured(locationCapture.getLocationCaptured());

                            compositeDisposable.add(iTimelineService.salvarNova(request)
                                    .observeOn(schedulerProvider.ui())
                                    .subscribeOn(schedulerProvider.io())
                                    .subscribe(result -> cadastrarNovaTimeline(result, request),
                                            throwable -> { LoggerUtils.error(throwable, this.getClass().getSimpleName());}));
                        }



//                        if (latitude != null && longitude != null) {
//                            mMsgView.setText(getString(R.string.msg_location_service_started) + "\n Latitude : " + latitude + "\n Longitude: " + longitude);
//                        }
                    }
                }, new IntentFilter(LocationMonitoringService.ACTION_LOCATION_BROADCAST)
        );
    }

    private void cadastrarNovaTimeline(ResponseTransfer<TimelineRequestResponse> result, CadastrarNovaTimelineNetworkingRequest request) {
        if (result.hasData()) {
            CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
            AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
            TimelineModel timelineModel = TimelineModel.cadastrarNovaTimeline(result.getData(), request, atendimentoModel);
            long insert = mTimelineDAO.insert(timelineModel);
            TimelineModel entity = mTimelineDAO.findByIdApp(insert);
            atendimentoModel.getTimelines().add(entity);
            atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
            mAtendimentoDAO.update(atendimentoModel);
        }
    }

    private void registerObservers() {
        mChamadoViewModel.getProgressLoading().observe(this, new Observer<ApiResponseList<ChamadoResponse>>() {
            @Override
            public void onChanged(@Nullable ApiResponseList<ChamadoResponse> response) {
                if (response != null) {
                    switch (response.status) {
                        case ERROR:
                            showLoading(false);
                            break;
                        case LOADING:
                            showLoading(true);
                            break;
                        case COMPLETED:
                        case SUCCESS:
                            showLoading(false);
                            break;
                        case ERRORBODY:
                            showLoading(false);
                            break;
                    }
                }
            }
        });

        mChamadoViewModel.getChamados().observe(this, new Observer<List<ChamadoItemRow>>() {
            @Override
            public void onChanged(@Nullable List<ChamadoItemRow> chamados) {
                if (CollectionUtils.isEmpty(chamados)) {
                    // TODO implementar..
                    // display sem chamados
                }

                updateAdapterUi(chamados);
            }
        });

        mChamadoViewModel.getChamadosFilter().observe(this, new Observer<DatabaseResponseList<ChamadoItemRow>>() {
            @Override
            public void onChanged(@Nullable DatabaseResponseList<ChamadoItemRow> responseList) {
                if (responseList != null) {
                    switch (responseList.status) {
                        case LOADING:
                            showLoading(true);
                            break;
                        case ERRORBODY:
                        case ERROR:
                            showLoading(false);
                            break;
                        case SUCCESS:
                            showLoading(false);
                            updateAdapterUi(responseList.response);
                            break;
                    }
                }
            }
        });
    }

    private void updateAdapterUi(List<ChamadoItemRow> chamadosHolder) {
        mChamadosAdapter.addNewItens(chamadosHolder);
        binding.rvChamados.setVisibility(View.VISIBLE);
    }

    @Override
    protected void setUp() {
        setSupportActionBar(binding.toolbar);

        binding.rvChamados.setVisibility(View.INVISIBLE);

        // Configure Recycler view
        binding.rvChamados.setLayoutManager(new LinearLayoutManager(MainActivity3.this));
        binding.rvChamados.setNestedScrollingEnabled(false);
        mChamadosAdapter = new ChamadosAdapter(MainActivity3.this, new ArrayList<>(), MainActivity3.this);
        mChamadosAdapter.setHasStableIds(true);
        binding.rvChamados.setAdapter(mChamadosAdapter);
        binding.rvChamados.addItemDecoration(new StickHeaderItemDecoration(mChamadosAdapter));
        binding.rvChamados.setItemViewCacheSize(20);
        // Vai ser fixo por enquanto
        binding.rvChamados.setHasFixedSize(true);
    }


    public static Intent getStartIntent(Context context) {
        return new Intent(context, MainActivity3.class);
    }

    @Override
    public void onItemClick(ChamadoItemRow chamadoSelecionado) {

        if (StatusChamado.ATIVO.equals(chamadoSelecionado.getStatus())) {
            //TODO implementar
            if (getCurrentChamadoAtendimento() == null) {
                mChamadoViewModel.sincronizarAtendimentoAtivo(chamadoSelecionado.getChamadoNumero());
            }

            Intent startIntent = openActivity(ChamadoManutencaoActivityJava.class);
            startActivity(startIntent);
        } else {
            sincronizarStatusAtualChamado(chamadoSelecionado);
        }

    }

    private void sincronizarStatusAtualChamado(ChamadoItemRow chamadoSelecionado) {
        compositeDisposable.add(chamadoService.getStatusChamado(chamadoSelecionado.getChamadoNumero())
                .subscribeOn(schedulerProvider.io())
                .observeOn(schedulerProvider.ui())
                .doOnSubscribe(d -> showLoading())
                .doOnTerminate(this::hideLoading)
                .subscribe(result -> {
                            if (result.hasData()) {
                                atualizarStatusChamado(result.getData(), chamadoSelecionado);
                            } else {
                                showDialogErroInterno();
                            }
                        },
                        throwable -> {
                            LoggerUtils.error(throwable, this.getClass().getSimpleName() + " Erro ao sincronizar classe");
                            showDialogErroInterno();
                        })
        );
    }

    private void atualizarStatusChamado(VerificarStatusChamadoDTO result, ChamadoItemRow chamadoItemRowClicked) {
        ChamadoStatus statusAtualChamado = result.getChamadoStatus();
        if (ChamadoStatus.O == statusAtualChamado || ChamadoStatus.C == statusAtualChamado) {
            ChamadoModel byIdChamadoWeb = mChamadoDAO.findByIdChamadoWeb(chamadoItemRowClicked.getChamadoNumero());
            byIdChamadoWeb.setStatusPortal(statusAtualChamado);
            byIdChamadoWeb.setStatusApp(StatusChamado.CONCLUIDOS);
            mChamadoDAO.update(byIdChamadoWeb);
            mChamadosAdapter.removeItem(chamadoItemRowClicked);
            String notification = "Chamado foi " +
                    (statusAtualChamado == ChamadoStatus.O ? "concluído" : "cancelado") +
                    " no portal.";
            Toasty.info(MainActivity3.this, notification, Toasty.LENGTH_LONG).show();
        } else {
            //continue
            abrirChamado(chamadoItemRowClicked);
        }
    }

    public void abrirChamado(ChamadoItemRow chamadoSelecionado) {
        Intent startIntent = openActivity(ChamadoDetailsActivity.class);
        startIntent.putExtra(AppConstants.CHAMADO_ID, chamadoSelecionado.getChamadoNumero());
        startIntent.putExtra(AppConstants.CHAMADO_SELECIONADO, chamadoSelecionado);
        startActivity(startIntent);
    }

    @Override
    public void openLoginActivity() {
        Intent intent = openActivity(MainActivity3.this, LoginActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        finish();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        getMenuInflater().inflate(R.menu.main2, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_filter :
                Intent startFilter = openActivity(ChamadoFilterActivity.class);
                startFilter.putExtra(AppConstants.FILTER_CHAMADO, chamadoFilter);
                startActivityForResult(startFilter, CODE_FILTER_CHAMADO);
                super.overridePendingTransitionEnter();
                return true;
            case R.id.action_logout:
                //mPresenter.onClickLogoutApp();
                deslogarApp();
                //mChamadoViewModel.logoutApp();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void deslogarApp() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this, R.style.AlertDialogTheme);
        builder.setTitle("Confirmar");
        builder.setMessage("Deseja realmente sair do app?");
        builder.setPositiveButton("Sim", (dialog, which) -> clearBase());
        builder.setNegativeButton("Não", (dialog, which) -> dialog.dismiss());
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public void clearBase() {
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
            @Override
            public void run() {
                compositeDisposable.add(atendimentoRepository.clearTables()
                        .subscribeOn(schedulerProvider.io())
                        .observeOn(schedulerProvider.ui())
                        .doOnSubscribe(d -> showLoading())
                        .doOnTerminate(() -> hideLoading())
                        .subscribe(result -> {
                                    if (result) {
                                        mPresenter.onClickLogoutApp();
                                    } else {
                                        showDialogErroInterno();
                                    }
                                },
                                throwable -> {
                                    LoggerUtils.error(throwable, this.getClass().getSimpleName() + " Erro ao deletar tabelas");
                                    showDialogErroInterno();
                                }));
            }
        }, 2000);
    }

    public void showLoading(boolean show) {
        if (show) {
            invisibleView(binding.rvChamados);
            visibleView(binding.pbLoadingChamados);
        } else {
            visibleView(binding.rvChamados);
            invisibleView(binding.pbLoadingChamados);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();

        if ( !isNetworkConnected() ) {
            noNetworkConnetedMessage();
            showLoading(false);
            return;
        }

        // Syncronize data
        if (chamadoFilter == null)
            mChamadoViewModel.loadChamados(new ChamadoFilter());
        else
            updateRecyclerView(chamadoFilter);


        //binding.pbLoadingChamados.setVisibility(View.VISIBLE);
        //binding.rvChamados.setVisibility(View.INVISIBLE);
        binding.clRetomarChamado.setVisibility(View.GONE);
        new Handler(Looper.getMainLooper()).post(() -> {
//                binding.rvChamados.setLayoutManager(new LinearLayoutManager(MainActivity3.this));
//                binding.rvChamados.setNestedScrollingEnabled(false);
//                List<ChamadoItemRow> mockList = ChamadosStatic.createStaticListWithFilter(chamadoFilter);
//                ChamadosAdapter chamadosAdapter = new ChamadosAdapter(MainActivity3.this, mockList, MainActivity3.this);
//                binding.rvChamados.setAdapter(chamadosAdapter);
//                binding.rvChamados.setVisibility(View.VISIBLE);
            //binding.pbLoadingChamados.setVisibility(View.INVISIBLE);

            CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
            if (currentChamadoAtendimento != null) {
                binding.clRetomarChamado.setVisibility(View.VISIBLE);
                binding.clRetomarChamado.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent startIntent = openActivity(MainActivity3.this, ChamadoManutencaoActivityJava.class);
                        startActivity(startIntent);
                    }
                });
                binding.textView2.setText("Retomar chamado "+ currentChamadoAtendimento.getChamadoModel().getIdChamadoWeb());
            }

//                CurrentChamado instance = CurrentChamado.getInstance();
//                if (instance.existeChamadoAtivo()) {
//                    binding.clRetomarChamado.setVisibility(View.VISIBLE);
//                    binding.clRetomarChamado.setOnClickListener(new View.OnClickListener() {
//                        @Override
//                        public void onClick(View v) {
//                            Intent startIntent = openActivity(MainActivity3.this, ChamadoManutencaoActivityJava.class);
//                            startActivity(startIntent);
//                        }
//                    });
//                    binding.textView2.setText("Retomar chamado "+ instance.getIdChamadoAtivo());
//                }
        });


        //startStep1();

    }

    private void startStep1() {

            //Check whether this user has installed Google play service which is being used by Location updates.
            if (isGooglePlayServicesAvailable()) {

                //Passing null to indicate that it is executing for the first time.
                startStep2(null);

            } else {
                Toast.makeText(getApplicationContext(), "Você precisa habilitar o google play", Toast.LENGTH_LONG).show();
            }
        }

    private void startStep2(Object o) {
        Dexter.withActivity(MainActivity3.this)
                .withPermission(Manifest.permission.ACCESS_FINE_LOCATION)
                .withListener(new PermissionListener() {
                    @Override
                    public void onPermissionGranted(PermissionGrantedResponse response) {
                        //Permissoes concedidas então pode continuar
                        //mPresenter.onIniciarChamadoClickListener();
                        startStep3();
                    }

                    @Override
                    public void onPermissionDenied(PermissionDeniedResponse response) {
                        if (response.isPermanentlyDenied()) {
                            showSettingsDialogLocalidade();
                        } else {
                            showDialogPermissaoLocalidade();
                        }
                    }

                    @Override
                    public void onPermissionRationaleShouldBeShown(PermissionRequest permission, PermissionToken token) {
                        token.continuePermissionRequest();
                    }
                })
                .withErrorListener(new PermissionRequestErrorListener() {
                    @Override
                    public void onError(DexterError error) {
                        showDialogErroInterno();
                        LoggerUtils.d("Dexter", "There was an error: " + error.toString());
                    }
                })
                .check();
        
    }

    private void startStep3() {

            //And it will be keep running until you close the entire application from task manager.
            //This method will executed only once.

        if (!mAlreadyStartedService) {

            //mMsgView.setText(R.string.msg_location_service_started);

            //Start location sharing service to app server.........
            Intent intent = new Intent(this, LocationMonitoringService.class);
            startService(intent);

            mAlreadyStartedService = true;
            //Ends................................................
        }
    }

    /**
     * Return the current state of the permissions needed.
     */
    private boolean checkPermissions() {
        int permissionState1 = ActivityCompat.checkSelfPermission(this,
                android.Manifest.permission.ACCESS_FINE_LOCATION);

        int permissionState2 = ActivityCompat.checkSelfPermission(this,
                Manifest.permission.ACCESS_COARSE_LOCATION);

        return permissionState1 == PackageManager.PERMISSION_GRANTED && permissionState2 == PackageManager.PERMISSION_GRANTED;

    }

    /**
     * Return the availability of GooglePlayServices
     */
    public boolean isGooglePlayServicesAvailable() {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int status = googleApiAvailability.isGooglePlayServicesAvailable(this);
        if (status != ConnectionResult.SUCCESS) {
            if (googleApiAvailability.isUserResolvableError(status)) {
                googleApiAvailability.getErrorDialog(this, status, 2404).show();
            }
            return false;
        }
        return true;
    }

    @Override
    public void showAboutFragment() {

    }

    @Override
    public void refreshQuestionnaire(List<Question> questionList) {

    }

    @Override
    public void reloadQuestionnaire(List<Question> questionList) {

    }

    @Override
    public void updateUserName(String currentUserName) {

    }

    @Override
    public void updateUserEmail(String currentUserEmail) {

    }

    @Override
    public void updateUserProfilePic(String currentUserProfilePicUrl) {

    }

    @Override
    public void updateAppVersion() {

    }

    @Override
    public void showRateUsDialog() {

    }

    @Override
    public void openMyFeedActivity() {

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == CODE_FILTER_CHAMADO && resultCode == RESULT_OK) {
            if (data != null && data.hasExtra(AppConstants.FILTER_CHAMADO)) {
                chamadoFilter = data.getParcelableExtra(AppConstants.FILTER_CHAMADO);
                updateRecyclerView(chamadoFilter);
            }
        }
    }

    private void updateRecyclerView(ChamadoFilterModel chamadoFilter) {
        mChamadoViewModel.fetchChamadosWithFilter(chamadoFilter);
    }

    @Override
    protected void onDestroy() {
        mPresenter.onDetach();
        chamadoFilter = null;
        binding.unbind();
        stopService(new Intent(this, LocationMonitoringService.class));
        mAlreadyStartedService = false;
        super.onDestroy();
    }
}
