package br.com.softilux.softiluxapp.ui.main;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.List;

import br.com.softilux.softiluxapp.R;

/**
 * Created by Vinicius on 02,Fevereiro,2019
 */
public class ItemRecyclerViewAdapter extends RecyclerView.Adapter<ItemRecyclerViewAdapter.ItemViewHolder> {

    class ItemViewHolder extends RecyclerView.ViewHolder {
        private TextView itemLabel;

        ItemViewHolder(View itemView) {
            super(itemView);
            itemLabel = itemView.findViewById(R.id.item_label);
        }
    }

    private Context context;
    private List<String> list;

    ItemRecyclerViewAdapter(Context context, List<String> list) {
        this.context = context;
        this.list = list;
    }

    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.item_custom_row_layout, parent, false);
        return new ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder holder, int position) {
        holder.itemLabel.setText(list.get(position));
    }

    @Override
    public int getItemCount() {
        return list.size();
    }


}
