package br.com.softilux.softiluxapp.ui.main;

import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.FragmentHistoricoAtendimentoBinding;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseFragment;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.core.utils.constants.AppConstants;

public class HistoricoAtendimentoFragment extends AbstractBaseFragment {
    private FragmentHistoricoAtendimentoBinding binding;

    public HistoricoAtendimentoFragment() {
        // Required empty public constructor
    }

    public static HistoricoAtendimentoFragment newInstance() {
        HistoricoAtendimentoFragment fragment = new HistoricoAtendimentoFragment();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_historico_atendimento, container, false);
        PresentationComponent activityComponent = getActivityComponent();
        if (activityComponent != null) {
            getActivityComponent().inject(this);
            //mPresenter.onAttach(this);
        }

        return binding.getRoot();
    }

    @Override
    protected void setUp(View view) {
        binding.cvShowRvEmpty.setVisibility(View.VISIBLE);
        //binding.cvShowRvEmpty.setVisibility(View.GONE);
        binding.pbLoadingAtendimentos.setVisibility(View.GONE);
        binding.rvAtendimentos.setVisibility(View.GONE);
//        ChamadosStatic pesquisar = ChamadosStatic.pesquisar(getIdChamado());
//        if (pesquisar != null && MapUtils.isNotEmpty(pesquisar.getAtendimentos())) {
//            binding.rvAtendimentos.setVisibility(View.GONE);
//            binding.pbLoadingAtendimentos.setVisibility(View.VISIBLE);
//            new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
//                @Override
//                public void run() {
//                    List<AtendimentoItemRow> atendimentoItemRowList = transformModelInHolder(pesquisar.getAtendimentos());
//                    binding.rvAtendimentos.setNestedScrollingEnabled(false);
//                    binding.rvAtendimentos.setHasFixedSize(true);
//                    binding.rvAtendimentos.setLayoutManager(new LinearLayoutManager(getBaseActivity()));
//                    binding.rvAtendimentos.setAdapter(new AtendimentoChamadoAdapter(getBaseActivity(),
//                            atendimentoItemRowList, new OnAtendimentoClickListener() {
//                        @Override
//                        public void onAtendimentoItemClick(AtendimentoItemRow atendimentoItemRow) {
//                            Intent startIntent = DetalhesAtendimentoActivity.getStartIntent(getBaseActivity());
//                            startIntent.putExtra(AppConstants.CHAMADO_ID, getIdChamado());
//                            startIntent.putExtra(AppConstants.ATENDIMENTO_ID, atendimentoItemRow.getIdAtendimento());
//                            getBaseActivity().startActivity(startIntent);
//                        }
//                    }));
//                    binding.pbLoadingAtendimentos.setVisibility(View.GONE);
//                    binding.rvAtendimentos.setVisibility(View.VISIBLE);
//                }
//            }, 2000);
//        } else {
//            binding.cvShowRvEmpty.setVisibility(View.VISIBLE);
//        }
    }

    private List<AtendimentoItemRow> transformModelInHolder(Map<Long, AtendimentoChamado> atendimentos) {
        List<AtendimentoItemRow> atendimentosHolder = new ArrayList<>(atendimentos.size());
        for (Map.Entry<Long, AtendimentoChamado> entry :  atendimentos.entrySet()) {
            AtendimentoItemRow atendimentoItemRow = new AtendimentoItemRow();
            atendimentoItemRow.setIdAtendimento(entry.getKey());
            atendimentoItemRow.setDataAtendimento(entry.getValue().getDataAceiteChamado());
            atendimentosHolder.add(atendimentoItemRow);
        }
        return atendimentosHolder;
    }

    private Long getIdChamado() {
        Long chamadoAtivo = null;
        if (getBaseActivity().getIntent().getExtras() != null)
            chamadoAtivo = getBaseActivity().getIntent().getExtras().getLong(AppConstants.CHAMADO_ID, 0L);
        return chamadoAtivo;
    }

    @Override
    public void onDetach() {
        super.onDetach();

    }



}
