package br.com.softilux.softiluxapp.ui.main;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.List;

import br.com.softilux.core.base.AbstractBaseViewHolder;
import br.com.softilux.core.ui.decoration.StickHeaderItemDecoration;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.databinding.ItemChamadoRowBinding;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoItemRow;
import br.com.softilux.core.utils.CommonUtils;

/**
 * Created by Vinicius on 07,Fevereiro,2019
 */
public class ChamadosAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements StickHeaderItemDecoration.StickyHeaderInterface {

    private Context mContext;
    private List<ChamadoItemRow> mDataSet;
    private ChamadoItemClickListener2 listener;

    public ChamadosAdapter(final Context mContext,
                           List<ChamadoItemRow> mDataSet,
                           final ChamadoItemClickListener2 listener) {
        this.mContext = mContext;
        this.mDataSet = mDataSet;
        this.listener = listener;
    }


    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(mContext);

        if (viewType == CommonUtils.VIEWTYPE_GROUP) {
            View inflate = inflater.inflate(R.layout.group_item_chamados, parent, false);
            return new GroupViewHolder(inflate);
        } else if (viewType == CommonUtils.VIEWTYPE_CHAMADO) {
            ItemChamadoRowBinding binding = DataBindingUtil.inflate(inflater, R.layout.item_chamado_row, parent, false);
           return new ChamadoViewHolder(binding);
        } else {
            View inflate = inflater.inflate(R.layout.group_item_chamados, parent, false);
            return new GroupViewHolder(inflate);
        }

    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        ChamadoItemRow row = mDataSet.get(position);
        if (holder instanceof GroupViewHolder) {
            ((GroupViewHolder) holder).bindData(row);
        } else if (holder instanceof ChamadoViewHolder) {
            ((ChamadoViewHolder) holder).bindData(row);
        }
    }

    @Override
    public long getItemId(int position) {
        return mDataSet.get(position).getChamadoNumero();
    }

    @Override
    public int getItemCount() {
        return mDataSet.size();
    }

    @Override
    public int getItemViewType(int position) {
        return mDataSet.get(position).getViewType();
    }

    /**
     *  Add new itens to recycler view
     *
     * */
    public void addNewItens(List<ChamadoItemRow> data) {
        mDataSet.clear();
        mDataSet.addAll(data);
        notifyDataSetChanged();
    }

    /**
     *  Remove item
     *
     * */
    public void removeItem(ChamadoItemRow chamadoItemRow) {
        int position = mDataSet.indexOf(chamadoItemRow);
        mDataSet.remove(position);
        notifyItemRemoved(position);
        notifyItemRangeChanged(position, mDataSet.size());
    }

    @Override
    public int getHeaderPositionForItem(int itemPosition) {
        int headerPosition = 0;
        do {
            if (this.isHeader(itemPosition)) {
                headerPosition = itemPosition;
                break;
            }
            itemPosition -= 1;
        } while (itemPosition >= 0);
        return headerPosition;
    }

    @Override
    public int getHeaderLayout(int headerPosition) {
        return R.layout.group_item_chamados;
    }

    @Override
    public void bindHeaderData(View header, int position) {
        TextView mTvGroupName = header.findViewById(R.id.tv_group_chamado_title);

        ChamadoItemRow model = mDataSet.get(position);
        String groupCount = !StatusChamado.ATIVO.getStatus().equals(model.getGroupName())
                ? " ( " + model.getGroupCount() + " ) " : "";
        String groupName = model.getGroupName() + groupCount;
        mTvGroupName.setText(groupName);
        mTvGroupName.setTextColor(mContext.getColor(model.getColor()));
    }

    @Override
    public boolean isHeader(int itemPosition) {
        return mDataSet.get(itemPosition).getViewType() == CommonUtils.VIEWTYPE_GROUP;
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
    }

    public class GroupViewHolder extends AbstractBaseViewHolder<ChamadoItemRow> {

        TextView mTvGroupName;

        public GroupViewHolder(@NonNull View itemView) {
            super(itemView);
            mTvGroupName = itemView.findViewById(R.id.tv_group_chamado_title);
        }

        @Override
        public void bindData(ChamadoItemRow model) {
            super.bindData(model);
            String groupCount = !StatusChamado.ATIVO.getStatus().equals(model.getGroupName())
                    ? " ( " + model.getGroupCount() + " ) " : "";
            String groupName = model.getGroupName() + groupCount;
            mTvGroupName.setText(groupName);
            mTvGroupName.setTextColor(mContext.getColor(model.getColor()));
        }

    }

    public class ChamadoViewHolder extends AbstractBaseViewHolder<ChamadoItemRow> {

        private final ItemChamadoRowBinding binding;

        public ChamadoViewHolder(ItemChamadoRowBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        @Override
        public void bindData(ChamadoItemRow model) {
            super.bindData(model);
            binding.getRoot().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listener.onItemClick(model);
                }
            });
            binding.tvChamadoNumeroValue.setText(model.getChamadoNumero() + " / " + model.getChamadoIluxNumero());
            binding.tvClienteChamadoValue.setText(model.getNomeCliente());
            binding.tvDataPrivisaoValue.setText(model.getDataPrevisaoAtendimento());
            binding.tvChamadoStatus.setText(model.getStatusPortal().getStatus());
            binding.tvChamadoStatus.setBackgroundResource(model.getStatusPortal().getColorLabel());
        }

    }
}
