package br.com.softilux.softiluxapp.ui.main;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;

import com.jakewharton.retrofit2.adapter.rxjava2.HttpException;

import org.apache.commons.lang3.BooleanUtils;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.utils.loading.DatabaseResponseList;
import br.com.softilux.core.webservice.ApiResponseList;
import br.com.softilux.core.webservice.ResponseListTransfer;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.db.model.ChamadoFilterModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.UsuarioLogado;
import br.com.softilux.softiluxapp.data.repository.ChamadoRepository;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoFilter;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoResponse;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoItemRow;
import br.com.softilux.softiluxapp.ui.login.BaseViewModel;

/**
 * Created by Vinicius on 30,Abril,2019
 */
public class ChamadoViewModel extends BaseViewModel {

    /**
     *  Repository (Networking and Database)
     * */
    private final ChamadoRepository chamadoRepository;

    /**
     *  Progress
     * */
    private final MutableLiveData<ApiResponseList<ChamadoResponse>> progressLoading = new MutableLiveData<>();

    /**
     *  Data to show in ui
     * */
    private final MutableLiveData<List<ChamadoItemRow>> mChamados = new MutableLiveData<>();

    /**
     *  Data to show in ui
     * */
    private final MutableLiveData<DatabaseResponseList<ChamadoItemRow>> mChamadosFilter = new MutableLiveData<>();

    /**
     *  Tag error
     * */
    private final String TAG = getClass().getSimpleName();

    @Inject
    public ChamadoViewModel(ChamadoRepository chamadoRepository) {
        this.chamadoRepository = chamadoRepository;
    }

    public LiveData<ApiResponseList<ChamadoResponse>> getProgressLoading() {
        return progressLoading;
    }

    public LiveData<List<ChamadoItemRow>> getChamados() {
        return mChamados;
    }

    public LiveData<DatabaseResponseList<ChamadoItemRow>> getChamadosFilter() {
        return mChamadosFilter;
    }

    public void loadChamados(ChamadoFilter chamadoFilter) {
        //    if (CollectionUtils.isEmpty(mChamados.getValue())) {

        //UsuarioLogado usuario = chamadoRepository.getCurrentUser();

        UsuarioLogado usuario = chamadoRepository.getUsuarioLogado();

        // Seta dados obrigatorios para o filtro
        chamadoFilter.setEmpId(usuario.getIdEmpresa());
        chamadoFilter.setNmSuporte(usuario.getIdTecnico());
        chamadoFilter.setIdBase(usuario.getIdEmpresa());

        this.fetchChamados(chamadoFilter);
        //  }
    }

    private void fetchChamados(final ChamadoFilter chamadoFilter) {
        chamadoRepository.getCompositeDisposable()
                .add(chamadoRepository.loadAllNetworking(chamadoFilter)
                    .subscribeOn(chamadoRepository.getSchedulerProvider().io())
                    .observeOn(chamadoRepository.getSchedulerProvider().ui())
                    .doOnSubscribe((d) -> progressLoading.setValue(ApiResponseList.loading()))
                    .subscribe(
                            this::renderSuccessResult,
                            this::renderErrorResult
                    ));
    }

    private void renderSuccessResult(ResponseListTransfer<ChamadoResponse> response) {
        if (response.hasData()) {
            List<ChamadoResponse> chamadosResponse = response.getData();
            List<ChamadoModel> persist = transformerToModel(chamadosResponse);
            //Salva todos os chamados e apos apresenta na ui
            saveChamados(persist, response);

        } else {
            progressLoading.setValue(ApiResponseList.success(response));
            mChamados.setValue(null);
        }
    }

    private void saveChamados(List<ChamadoModel> persist, ResponseListTransfer<ChamadoResponse> response) {
        chamadoRepository.getCompositeDisposable()
                .add(chamadoRepository.observableSaveAllDatabase(persist)
                .subscribeOn(chamadoRepository.getSchedulerProvider().io())
                .observeOn(chamadoRepository.getSchedulerProvider().ui())
                .subscribe(
                    result -> renderSuccessResult(result, response),
                        this::renderErrorSaveAllResult
                ));
    }

    private void renderErrorSaveAllResult(Throwable throwable) {

    }

    private void renderSuccessResult(Boolean result, ResponseListTransfer<ChamadoResponse> response) {
        if (BooleanUtils.isTrue(result)) {
            renderChamadosInUi(response);
        }
    }

    private void renderChamadosInUi(ResponseListTransfer<ChamadoResponse> response) {
        chamadoRepository
                .getCompositeDisposable()
                .add(chamadoRepository.observableLoadAllDatabaseGroup()
                .subscribeOn(chamadoRepository.getSchedulerProvider().io())
                .observeOn(chamadoRepository.getSchedulerProvider().ui())
                .subscribe(
                    result -> renderSuccessResult(result, response),
                        this::renderErrorDataResult
                ));
    }

    private void renderSuccessResult(List<ChamadoItemRow> result, ResponseListTransfer<ChamadoResponse> response) {
        // Carregar chamados salvos para a tela
        progressLoading.setValue(ApiResponseList.success());
        mChamados.setValue(result);
    }

    private void renderErrorDataResult(Throwable throwable) {

    }

//    private void renderSuccessDataResult(List<ChamadoModel> result, ResponseListTransfer<ChamadoResponse> response) {
//        // Carregar chamados salvos para a tela
//        progressLoading.setValue(ApiResponseList.success(response));
//        mChamados.setValue(result);
//    }

    private List<ChamadoModel> transformerToModel(List<ChamadoResponse> chamadosResponse) {
        List<ChamadoModel> models = new ArrayList<>();

        chamadosResponse.forEach(response -> models.add(response.toModel()));
//        for (ChamadoResponse chamadoReponse: chamadosResponse) {
//            models.add(chamadoReponse.toModel());
//        }

        return models;
    }

    private void renderErrorResult(Throwable throwable) {
        if (throwable instanceof HttpException) {
            HttpException error = (HttpException) throwable;
            //handlerCallbackErrorResult2(error.response().code(), error.response().errorBody());
        } else {
            progressLoading.setValue(ApiResponseList.error(throwable));
            LoggerUtils.error(throwable, TAG + " fetchChamados()");
        }
    }

    public void fetchChamadosWithFilter(final ChamadoFilterModel chamadoFilterModel) {
        if (chamadoFilterModel != null && chamadoFilterModel.isPreenchido()) {
            chamadoRepository.getCompositeDisposable()
                    .add(chamadoRepository.observableLoadAllWithFilterDatabaseGroup(chamadoFilterModel)
                            .subscribeOn(chamadoRepository.getSchedulerProvider().io())
                            .observeOn(chamadoRepository.getSchedulerProvider().ui())
                            .doOnSubscribe((d) -> mChamadosFilter.setValue(DatabaseResponseList.loading()))
                            .subscribe(
                                    this::renderSuccessResult,
                                    this::renderErrorResult
                            ));
        } else {
            renderChamadosInUi(null);
        }
    }

    private void renderSuccessResult(List<ChamadoItemRow> result) {
        mChamadosFilter.setValue(DatabaseResponseList.success(result));
    }

//    public void logoutApp() {
//        //TODO implementar logout
//        // Criar chamada assincrona dentro do repository
//
//
//
//        // Part paper
//        chamadoRepository.getPaperBook().setLogginMode(DataManager.LoggedInMode.LOGGED_IN_MODE_LOGGED_OUT);
//        chamadoRepository.getPaperBook().deleteUsuarioLogado();
//        chamadoRepository.getPaperBook().deleteNomesClientes();
//        chamadoRepository.getPaperBook().deleteDataHoraSincronizacaoChamados();
//
//    }

    @Override
    protected void onCleared() {
        chamadoRepository.getCompositeDisposable().dispose();
        super.onCleared();
    }

    public void sincronizarAtendimentoAtivo(Long chamadoNumero) {
//        chamadoRepository.getCompositeDisposable()
//                .add(chamadoRepository.getAtendimentoAtivoComTimelines(chamadoNumero)
//                        .subscribeOn(chamadoRepository.getSchedulerProvider().io())
//                        .observeOn(chamadoRepository.getSchedulerProvider().ui())
//                        .doOnSubscribe(//(d) -> mChamadosFilter.setValue(DatabaseResponseList.loading())
//                                 )
//                        .subscribe(
//                                this::renderSuccessResult,
//                                this::renderErrorResult
//                        ));
    }
}