package br.com.softilux.softiluxapp.ui.main

import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MutableLiveData

import javax.inject.Inject

import br.com.softilux.core.utils.LoggerUtils
import br.com.softilux.core.utils.loading.DatabaseResponse
import br.com.softilux.core.webservice.ApiResponse
import br.com.softilux.core.webservice.ResponseTransfer
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel
import br.com.softilux.softiluxapp.data.repository.AtendimentoRepository
import br.com.softilux.softiluxapp.data.repository.ChamadoRepository
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoRequest
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoResponse
import br.com.softilux.softiluxapp.ui.login.BaseViewModel

/**
 * Created by Vinicius on 30,Abril,2019
 */
class ChamadoDetailsViewModel2 @Inject
    constructor(
        private val chamadoRepository: ChamadoRepository,
        private val atendimentoRepository: AtendimentoRepository) : BaseViewModel() {

    /**
     * Progress
     */
    private val progressLoading = MutableLiveData<ApiResponse<ChamadoModel>>()

    /**
     * Progress
     */
    private val progress = MutableLiveData<DatabaseResponse<AtendimentoModel>>()

    /**
     *
     */
    private val progressSaveAtendimentoNetwoking = MutableLiveData<ApiResponse<NovoAtendimentoRequest>>()

    /**
     * Live data for observers
     */
    private val mChamadoModelObserver = MutableLiveData<ChamadoModel>()

    /**
     * Chamado model, cached
     */
    var chamadoModel: ChamadoModel? = null

    /**
     * Tag error
     */
    private val TAG = javaClass.simpleName

    val chamadoModelObserver: LiveData<ChamadoModel>
        get() = mChamadoModelObserver

    fun getProgressLoading(): LiveData<ApiResponse<ChamadoModel>> {
        return progressLoading
    }

    fun getProgress(): LiveData<DatabaseResponse<AtendimentoModel>> {
        return progress
    }

    fun getProgressSaveAtendimentoNetwoking(): LiveData<ApiResponse<NovoAtendimentoRequest>> {
        return progressSaveAtendimentoNetwoking
    }

    fun findOneByIdChamado(id: Long) {
        //Se não existe chamado carregado ou é outro chamado, carrega o chamado.
        if (mChamadoModelObserver.value == null || mChamadoModelObserver.value!!.idChamadoWeb != id) {
            chamadoRepository.compositeDisposable
                    .add(chamadoRepository.observableFindOneDatabase(id)
                            .subscribeOn(chamadoRepository.schedulerProvider.io())
                            .observeOn(chamadoRepository.schedulerProvider.ui())
                            .doOnSubscribe { d -> progressLoading.setValue(ApiResponse.loading()) }
                            .subscribe(
                                    { result -> renderSuccessResult(result) },
                                    { throwable -> renderErrorResult(throwable, id) }
                            ))
        }
    }

    private fun renderErrorResult(throwable: Throwable, id: Long?) {
        LoggerUtils.error(throwable, "$TAG findOneByIdChamado() com id =$id")
        progressLoading.value = ApiResponse.error(throwable)
    }

    private fun renderSuccessResult(result: ChamadoModel) {
        progressLoading.value = ApiResponse.success()
        mChamadoModelObserver.value = result
        chamadoModel = result
    }

    fun salvarAtendimentoDatabase(atendimentoModel: AtendimentoModel?) {
        if (atendimentoModel != null) {
            atendimentoRepository
                    .compositeDisposable
                    .add(atendimentoRepository.saveNew(atendimentoModel)
                            .subscribeOn(chamadoRepository.schedulerProvider.io())
                            .observeOn(chamadoRepository.schedulerProvider.ui())
                            .doOnSubscribe { d -> progress.setValue(DatabaseResponse.loading()) }
                            .subscribe(
                                    { result -> progress.setValue(DatabaseResponse.success(result)) },
                                    { throwable -> progress.setValue(DatabaseResponse.error(throwable)) }
                            ))
        }
    }

    fun sendAtendimentoNetworking(response: AtendimentoModel) {
        atendimentoRepository
                .compositeDisposable
                .add(atendimentoRepository.saveNewNetworking(response)
                        .subscribeOn(chamadoRepository.schedulerProvider.io())
                        .observeOn(chamadoRepository.schedulerProvider.ui())
                        .doOnSubscribe { d -> progressSaveAtendimentoNetwoking.setValue(ApiResponse.loading()) }
                        .subscribe(
                                { result -> salvarRetornoNovoAtendimento(result)},
                                { throwable -> progressSaveAtendimentoNetwoking.setValue(ApiResponse.error(throwable)) }
                        ))
    }

    private fun salvarRetornoNovoAtendimento(result: ResponseTransfer<NovoAtendimentoResponse>?) {

    }

    override fun onCleared() {
        chamadoRepository.compositeDisposable.dispose()
        atendimentoRepository.compositeDisposable.dispose()
        chamadoModel = null
        super.onCleared()
    }
}