package br.com.softilux.softiluxapp.ui.main;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.os.Handler;
import android.support.annotation.NonNull;

import javax.inject.Inject;

import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.utils.loading.DatabaseResponse;
import br.com.softilux.core.webservice.ApiResponse;
import br.com.softilux.core.webservice.ResponseTransfer;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.repository.AtendimentoRepository;
import br.com.softilux.softiluxapp.data.repository.ChamadoRepository;
import br.com.softilux.softiluxapp.transfer.datatransfer.NovoAtendimentoResponse;
import br.com.softilux.softiluxapp.ui.login.BaseViewModel;

/**
 * Created by Vinicius on 30,Abril,2019
 */
public class ChamadoDetailsViewModel extends BaseViewModel {

    /**
     *  Repository (Networking and Database)
     * */
    private final ChamadoRepository chamadoRepository;

    /**
     *  Repository (Networking and Database)
     * */
    private final AtendimentoRepository atendimentoRepository;

    /**
     *  Progress
     * */
    private final MutableLiveData<ApiResponse<ChamadoModel>> progressLoading = new MutableLiveData<>();

    /**
     *  Progress
     *
        private final MutableLiveData<DatabaseResponse<AtendimentoModel>> progress = new MutableLiveData<>();
     */

    /**
     *
     * */
    private final MutableLiveData<DatabaseResponse<CurrentChamadoAtendimento>> progressSaveAtendimentoNetwoking = new MutableLiveData<>();

    /**
     * Live data for observers
     * */
    private final MutableLiveData<ChamadoModel> mChamadoModelObserver = new MutableLiveData<>();

    /**
     * Chamado model, cached
     * */
    private ChamadoModel chamadoModel;

    /**
     *  Tag error
     * */
    private final String TAG = getClass().getSimpleName();

    @Inject
    public ChamadoDetailsViewModel(ChamadoRepository chamadoRepository,
            AtendimentoRepository atendimentoRepository) {
        this.chamadoRepository = chamadoRepository;
        this.atendimentoRepository = atendimentoRepository;
    }

    public LiveData<ApiResponse<ChamadoModel>> getProgressLoading() {
        return progressLoading;
    }

//    public LiveData<DatabaseResponse<AtendimentoModel>> getProgress() {
//        return progress;
//    }

    public LiveData<DatabaseResponse<CurrentChamadoAtendimento>> getProgressSaveAtendimentoNetwoking() {
        return progressSaveAtendimentoNetwoking;
    }

    public LiveData<ChamadoModel> getChamadoModelObserver() {
        return mChamadoModelObserver;
    }

    public ChamadoModel getChamadoModel() {
        return chamadoModel;
    }

    public void setChamadoModel(ChamadoModel chamadoModel) {
        this.chamadoModel = chamadoModel;
    }

    public void findOneByIdChamado(Long id) {
        //Se não existe chamado carregado ou é outro chamado, carrega o chamado.
        if (mChamadoModelObserver.getValue() == null || !mChamadoModelObserver.getValue().getIdChamadoWeb().equals(id)) {
            chamadoRepository.getCompositeDisposable()
                    .add(chamadoRepository.observableFindOneDatabase(id)
                    .subscribeOn(chamadoRepository.getSchedulerProvider().io())
                    .observeOn(chamadoRepository.getSchedulerProvider().ui())
                    .doOnSubscribe((d) -> progressLoading.setValue(ApiResponse.loading()))
                    .subscribe(
                            result -> renderSuccessResult(result),
                            throwable -> renderErrorResult(throwable, id)
                    ));
        }
    }

    private void renderErrorResult(Throwable throwable, Long id) {
        LoggerUtils.error(throwable, TAG + " findOneByIdChamado()" + " com id =" + id);
        progressLoading.setValue(ApiResponse.error(throwable));
    }

    private void renderSuccessResult(ChamadoModel result) {
        progressLoading.setValue(ApiResponse.success());
        mChamadoModelObserver.setValue(result);
        setChamadoModel(result);
    }

//    public void salvarAtendimentoDatabase(AtendimentoModel atendimentoModel) {
//        if (atendimentoModel != null) {
//            atendimentoRepository
//                    .getCompositeDisposable()
//                    .add(atendimentoRepository.saveNew(atendimentoModel)
//                    .subscribeOn(chamadoRepository.getSchedulerProvider().io())
//                    .observeOn(chamadoRepository.getSchedulerProvider().ui())
//                    .doOnSubscribe((d) -> progress.setValue(DatabaseResponse.loading()))
//                    .subscribe(
//                            this::retornarAposSalvarChamado,
//                            throwable -> progress.setValue(DatabaseResponse.error(throwable))
//                    ));
//        }
//    }

//    private void retornarAposSalvarChamado(AtendimentoModel result) {
//        new Handler().postDelayed(new Runnable() {
//            @Override
//            public void run() {
//                progress.setValue(DatabaseResponse.success(result));
//            }
//        },3000);
//    }

    public void salvarNovoAtendimentoNoPortal(@NonNull AtendimentoModel response) {
        atendimentoRepository
                .getCompositeDisposable()
                .add(atendimentoRepository.saveNewNetworking(response)
                    .subscribeOn(chamadoRepository.getSchedulerProvider().io())
                    .observeOn(chamadoRepository.getSchedulerProvider().ui())
                    .doOnSubscribe((d) -> progressSaveAtendimentoNetwoking.setValue(DatabaseResponse.loading()))
                    .subscribe(
                            result -> processarRetornoNovoAtendimento(result, response),
                            throwable -> progressSaveAtendimentoNetwoking.setValue(DatabaseResponse.error(throwable))
                    ));
    }

    private void processarRetornoNovoAtendimento(ResponseTransfer<NovoAtendimentoResponse> result, AtendimentoModel response) {
        if (result.hasData()) {
            CurrentChamadoAtendimento currentChamadoAtendimento = atendimentoRepository.inserirNovoAtendimento(result.getData(), response);
            LoggerUtils.info("Atualizou atendimento e deu tudo certo");
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    progressSaveAtendimentoNetwoking.setValue(DatabaseResponse.success(currentChamadoAtendimento));
                }
            },2000);
        }
    }

    @Override
    protected void onCleared() {
        chamadoRepository.getCompositeDisposable().dispose();
        atendimentoRepository.getCompositeDisposable().dispose();
        chamadoModel = null;
        super.onCleared();
    }
}