package br.com.softilux.softiluxapp.ui.main;

import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;

import javax.inject.Inject;

import br.com.softilux.core.utils.constants.AppConstants;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.databinding.ActivityChamadoDetailsBinding;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoActivityJava;
import br.com.softilux.softiluxapp.ui.chamado.ChamadosStatic;
import br.com.softilux.softiluxapp.ui.chamado.CurrentChamado;

/**
 * Created by Vinicius on 01,Fevereiro,2019
 */
//implements ChamadoDetailsMvpView
public class ChamadoDetailsActivityJava extends AbstractBaseActivity  {

//    @Inject
//    ChamadoDetailsMvpPresenter<ChamadoDetailsMvpView> mPresenter;

    ActivityChamadoDetailsBinding binding;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_chamado_details);
        getActivityComponent().inject(this);
        //mPresenter.onAttach(this);
        setUp();
    }

    public static Intent getStartIntent(Context context) {
        return new Intent(context, ChamadoDetailsActivityJava.class);
    }

    @Override
    protected void setUp() {
        ChamadosStatic find = ChamadosStatic.pesquisar(getIdChamado());
        //setSupportActionBar(binding.toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle("Chamado "+ find.getChamadoNumero() + " / " + find.getChamadoIluxNumero());
        }

        binding.map.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String query = find.getNumeroEnderecoCliente() + " " + find.getEnderecoCliente() + ", " + find.getCidadeCliente() + ", Brasil";
                Uri gmmIntentUri = Uri.parse("geo:0,0?q=" + query);
                Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
                mapIntent.setPackage("com.google.android.apps.maps");
                startActivity(mapIntent);
            }
        });

        if (find != null)
        {
            binding.tvNomeTecnico.setText(find.getNomeTecnico());
            binding.tvDataAberturaChamado.setText(find.getDataHoraAberturaChamado());
            binding.tvDataPrevisaoAtendimento.setText(find.getDataPrevisaoAtendimento());
            binding.tvModalidadeChamado.setText(find.getModalidadeChamado());
            binding.tvTipoChamado.setText(find.getTipoChamado());
            binding.tvDefeitoMaquina.setText(find.getDefeitoChamado());
            binding.tvDefeitoCliente.setText(find.getDefeitoRelatadoCliente());
            binding.tvClienteChamado.setText(find.getIdCliente() + " - " + find.getNomeCliente());
            binding.tvEnderecoCliente.setText(find.getEnderecoCliente() + " , " + find.getNumeroEnderecoCliente());
            binding.tvBairroCliente.setText(find.getBairroCliente() );
            binding.tvCepCliente.setText(find.getCepCliente());
            binding.tvCidadeCliente.setText(find.getCidadeCliente());
            binding.tvUfCliente.setText(find.getUfCliente());
            binding.tvContatoCliente.setText(find.getContatoCliente());
            binding.tvFoneCliente.setText(find.getTelefoneCliente());
            binding.tvEmailCliente.setText(find.getEmailCliente());
            binding.tvSerieEquipamento.setText(find.getSerieEquipamento());
            binding.tvPatrimonioEquipamento.setText(find.getPatrimonioEquipamento());
            binding.tvModeloEquipamento.setText(find.getModeloEquipamento());
            binding.tvDepartamentoEquipamento.setText(find.getDepartamentoEquipamento());
            binding.tvLocalInstalacaoEquipamento.setText(find.getLocalInstalacaoEquipamento());
        }

        CurrentChamado currentChamado = CurrentChamado.getInstance();
        // -- Existe chamado ativo error visualização do chamado atual é diferente do ativo
        if ( currentChamado.existeChamadoAtivo() && !currentChamado.getIdChamadoAtivo().equals(getIdChamado())) {
            binding.btnIniciarChamado.setVisibility(View.GONE);
            binding.clRetomarChamado.setVisibility(View.VISIBLE);
        }

    }

    private Long getIdChamado() {
        Long chamadoAtivo = null;
        if (getIntent().getExtras() != null)
            chamadoAtivo = getIntent().getExtras().getLong(AppConstants.CHAMADO_ID, 0L);
        return chamadoAtivo;
    }

//    @Override
//    public void openChamadoActivity() {
//        updateChamadoAtivo();
//        Intent startIntent = ChamadoManutencaoActivityJava.getStartIntent(ChamadoDetailsActivityJava.this);
//        startActivity(startIntent);
//        finish();
//    }

    private void updateChamadoAtivo() {
        //Atualizar chamado ativo
        ChamadosStatic find = ChamadosStatic.pesquisar(getIdChamado());
        find.setStatusAnterior(find.getStatus());
        find.setStatus(StatusChamado.ATIVO);

        //Criar novo atendimento error atualizar chamado;
        AtendimentoChamado atendimentoChamado = new AtendimentoChamado();
        atendimentoChamado.setId(find.getAtendimentos().size() + 1L);
        find.getAtendimentos().put(atendimentoChamado.getId(), atendimentoChamado);
        find.salvar();

        //Alterar chamado statico
        CurrentChamado instance = CurrentChamado.getInstance();
        instance.setIdChamadoAtivo(getIdChamado());
        instance.setCurrentChamado(find);
        instance.setCurrentAtendimentoChamado(atendimentoChamado);
        instance.setIdAtendimentoChamadoAtivo(atendimentoChamado.getId());
    }

    @Override
    protected void onDestroy() {
//        mPresenter.onDetach();
        super.onDestroy();
    }
}
