package br.com.softilux.softiluxapp.ui.main;

import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;

import br.com.softilux.core.ui.adapter.SimpleViewPagerAdapter;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.utils.constants.AppConstants;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.ActivityChamadoDetailsJavaBinding;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoItemRow;

/**
 * Created by Vinicius on 14,Fevereiro,2019
 */
public class ChamadoDetailsActivity extends AbstractBaseActivity {

    /**
     * Binding desta activity
     * */
    private ActivityChamadoDetailsJavaBinding binding;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_chamado_details_java);
        getActivityComponent().inject(this);
        setUp();
    }

    @Override
    protected void setUp() {
        ChamadoItemRow chamadoSelecionado = getChamadoSelecionado();
        setSupportActionBar(binding.toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle(chamadoSelecionado.getToolbarTitle());
        }

        SimpleViewPagerAdapter viewPagerAdapter = new SimpleViewPagerAdapter(getSupportFragmentManager());
        viewPagerAdapter.addFragments(ChamadoDetailFragment.newInstance(), ChamadoDetailFragment.THIS_TITLE);
        // TODO implementar em outro no segundo MVP
        viewPagerAdapter.addFragments(HistoricoAtendimentoFragment.newInstance(), "Historico");
        binding.vpContainer.setAdapter(viewPagerAdapter);
        binding.tlContainer.setupWithViewPager(binding.vpContainer);
    }

    private ChamadoItemRow getChamadoSelecionado() {
        ChamadoItemRow chamadoSelecionado = null;
        if (getIntent().getExtras() != null) {
            chamadoSelecionado = getIntent()
                    .getExtras()
                    .getParcelable(AppConstants.CHAMADO_SELECIONADO);
        }
        LoggerUtils.d("Chamado selecionado= " + chamadoSelecionado);
        return chamadoSelecionado;
    }

}
