package br.com.softilux.softiluxapp.ui.main;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class ChamadoDetailPresenter <V extends ChamadoDetailsMvpView> extends BasePresenter<V>
        implements ChamadoDetailsMvpPresenter<V> {

    @Inject
    public ChamadoDetailPresenter(DataManager dataManager,
                                  SchedulerProvider schedulerProvider,
                                  CompositeDisposable compositeDisposable,
                                  ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable, configDAO);
    }

    @Override
    public void onIniciarChamadoClickListener() {
        getMvpView().openChamadoActivity();
    }

    @Override
    public void verificarPermissoes() {
        getMvpView().verificarPermissoes();
    }

}
