package br.com.softilux.softiluxapp.ui.main;

import android.Manifest;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.location.Address;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.DexterError;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.PermissionRequestErrorListener;
import com.karumi.dexter.listener.single.PermissionListener;

import org.jetbrains.annotations.NotNull;

import javax.inject.Inject;

import br.com.softilux.core.utils.GeocoderUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.utils.loading.DatabaseResponse;
import br.com.softilux.core.webservice.ApiResponse;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.LocationCapture;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.databinding.ActivityChamadoDetailsBinding;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.di.presentation.ViewModelFactory;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseFragment;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoItemRow;
import br.com.softilux.softiluxapp.ui.chamado.ChamadoManutencaoActivityJava;
import br.com.softilux.softiluxapp.ui.chamado.ChamadosStatic;
import br.com.softilux.softiluxapp.ui.chamado.CurrentChamado;
import br.com.softilux.core.utils.constants.AppConstants;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

/**
 * Created by Vinicius on 14,Fevereiro,2019
 */
public class ChamadoDetailFragment extends AbstractBaseFragment implements ChamadoDetailsMvpView {

    /**
     * For use in adapter, title of section.
     * */
    public static final String THIS_TITLE = "Chamado";

    @Inject
    ChamadoDetailsMvpPresenter<ChamadoDetailsMvpView> mPresenter;

    /**
     * Binding this fragment
     * */
    ActivityChamadoDetailsBinding binding;

    /**
     *  Factory to load view model
     * */
    @Inject
    ViewModelFactory viewModelFactory;

    @Inject
    CompositeDisposable compositeDisposable;

    @Inject
    SchedulerProvider schedulerProvider;


    /*
     * View model que observa esta atividade
     * */
    private ChamadoDetailsViewModel mChamadoDetailsViewModel;

    public static ChamadoDetailFragment newInstance() {
        return new ChamadoDetailFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        binding = DataBindingUtil.inflate(inflater, R.layout.activity_chamado_details, container, false);

        PresentationComponent activityComponent = getActivityComponent();
        if (activityComponent != null) {
            getActivityComponent().inject(this);
            mPresenter.onAttach(this);
        }

        mChamadoDetailsViewModel = ViewModelProviders.of(this, viewModelFactory).get(ChamadoDetailsViewModel.class);
        registerObservers();

        return binding.getRoot();
    }

    private void registerObservers() {
        mChamadoDetailsViewModel.getProgressLoading().observe(this, new Observer<ApiResponse<ChamadoModel>>() {
            @Override
            public void onChanged(@Nullable ApiResponse<ChamadoModel> response) {
                if (response != null) {
                    switch (response.status) {
                        case ERROR:
                            showLoading(false);
                            break;
                        case LOADING:
                            showLoading(true);
                            break;
                        case COMPLETED:
                        case SUCCESS:
                            showLoading(false);
                            break;
                        case ERRORBODY:
                            showLoading(false);
                            break;
                    }
                } else {
                    showDialogErroInterno();
                }
            }
        });

        mChamadoDetailsViewModel.getChamadoModelObserver().observe(this, new Observer<ChamadoModel>() {
            @Override
            public void onChanged(@Nullable ChamadoModel chamadoModel) {
                if (chamadoModel != null) {
                    updateTelaVisualizacaoChamado(chamadoModel);
                } else {
                    showDialogErroInterno();
                }
            }
        });

//        mChamadoDetailsViewModel.getProgress().observe(this, new Observer<DatabaseResponse<AtendimentoModel>>() {
//            @Override
//            public void onChanged(@Nullable DatabaseResponse<AtendimentoModel> atendimentoModelDatabaseResponse) {
//                if (atendimentoModelDatabaseResponse != null) {
//                    switch (atendimentoModelDatabaseResponse.status){
//                        case LOADING:
//                            //showProgressDialog(true);
//                            showLoading();
//                            break;
//                        case ERROR:
//                            //showProgressDialog(false);
//                            hideLoading();
//                            LoggerUtils.error("Erro ao salvar", atendimentoModelDatabaseResponse.error);
//                            break;
//                        case ERRORBODY:
//                            //showProgressDialog(false);
//                            hideLoading();
//                            LoggerUtils.error("ErroBody ao salvar", atendimentoModelDatabaseResponse.error);
//                            break;
//                        case SUCCESS:
//                        case COMPLETED:
//                            hideLoading();
//                            //showProgressDialog(false);
//                            LoggerUtils.error("Terminou de salvar", atendimentoModelDatabaseResponse.response);
//                            //enviarAtendimentoParaPortal(atendimentoModelDatabaseResponse.response);
//                            break;
//                    }
//                }
//            }
//        });

        mChamadoDetailsViewModel.getProgressSaveAtendimentoNetwoking().observe(this, new Observer<DatabaseResponse<CurrentChamadoAtendimento>>() {
            @Override
            public void onChanged(@Nullable DatabaseResponse<CurrentChamadoAtendimento> currentChamadoAtendimentoDatabaseResponse) {
                if (currentChamadoAtendimentoDatabaseResponse != null) {
                    switch (currentChamadoAtendimentoDatabaseResponse.status) {
                        case LOADING:
                            showProgressDialog(true);
                            break;
                        case ERROR:
                            showProgressDialog(false);
                            LoggerUtils.error("Deu erro", currentChamadoAtendimentoDatabaseResponse.error);
                            break;
                        case ERRORBODY:
                            showProgressDialog(false);
                            LoggerUtils.error("Deu erro com corpo", currentChamadoAtendimentoDatabaseResponse.error);
                            break;
                        case SUCCESS:
                        case COMPLETED:
                            showProgressDialog(false);
                            LoggerUtils.info("Finalizou chamada e salvou tudo", currentChamadoAtendimentoDatabaseResponse.response);
                            //enviarAtendimentoParaPortal(atendimentoModelDatabaseResponse.response);
                            CurrentChamadoAtendimento response = currentChamadoAtendimentoDatabaseResponse.response;
                            if (response != null) {
                                atualizarCurrentChamadoAtendimento(response);
                                Intent intent = getBaseActivity().openActivity(getContext(), ChamadoManutencaoActivityJava.class);
                                startActivity(intent);
                                getBaseActivity().finish();
                            } else {
                                showDialogErroInterno();
                            }
                            break;
                    }
                }
            }
        });

    }

    private void enviarAtendimentoParaPortal(@Nullable AtendimentoModel response) {
        if (response == null) {
            showDialogErroInterno();
            return;
        }

        mChamadoDetailsViewModel.salvarNovoAtendimentoNoPortal(response);
    }

    private void showProgressDialog(boolean show) {
        if (show)  {
            showSpotsDialog();
        } else {
            hideSpotsLoading();
        }
    }

    private void updateTelaVisualizacaoChamado(@NotNull ChamadoModel find) {
        //Preencher chamado
        binding.tvNomeTecnico.setText(find.getNmSuporte());
        binding.tvDataAberturaChamado.setText(find.getDataInclusaoCompletaAsString());
        binding.tvDataPrevisaoAtendimento.setText(find.getDataPrevisaoCompletaAsString());
        binding.tvModalidadeChamado.setText(find.getModalidadeOs() != null ? find.getModalidadeOs().getNome() : "");
        binding.tvTipoChamado.setText(find.getNmOSTp());
        binding.tvDefeitoMaquina.setText(find.getNmDefeito());
        binding.tvDefeitoCliente.setText(find.getObservacaoDefeitoCli());
        binding.tvClienteChamado.setText(find.getClienteCompletoAsString());
        binding.tvEnderecoCliente.setText(find.getEnderecoCompletoAsString());
        binding.tvBairroCliente.setText(find.getBairro());
        binding.tvCepCliente.setText(find.getCep());
        binding.tvCidadeCliente.setText(find.getCidade());
        binding.tvUfCliente.setText(find.getUf());
        binding.tvContatoCliente.setText(find.getContato());
        binding.tvFoneCliente.setText(find.getFone());
        binding.tvEmailCliente.setText(find.getEmail());
        binding.tvSerieEquipamento.setText(find.getSerieEquipamento());
        binding.tvPatrimonioEquipamento.setText(find.getPatrimonio());
        binding.tvModeloEquipamento.setText(find.getModelo());
        binding.tvDepartamentoEquipamento.setText(find.getDepartamento());
        binding.tvLocalInstalacaoEquipamento.setText(find.getLocalInstalacao());

        // Habilita o botão do google maps
        binding.map.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String query = find.getEnderecoGoogleMaps();
                Uri gmmIntentUri = Uri.parse("geo:0,0?q=" + query);
                Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
                mapIntent.setPackage("com.google.android.apps.maps");
                startActivity(mapIntent);
            }
        });


        binding.clContainerMasterParent.setVisibility(View.VISIBLE);
        if (getCurrentChamadoAtendimento() != null) {
            binding.btnIniciarChamado.setEnabled(false);
            binding.btnIniciarChamado.setVisibility(View.GONE);
            binding.clRetomarChamado.setVisibility(View.VISIBLE);
        } else {
            // Configurar botão iniciar chamado
            binding.clRetomarChamado.setVisibility(View.GONE);
            binding.btnIniciarChamado.setEnabled(true);
            binding.btnIniciarChamado.setOnClickListener(v -> mPresenter.verificarPermissoes());
            //Deixa o container visivel
        }

    }

    public void showLoading(boolean show) {
        if (show) {
            binding.progressLoading.setVisibility(View.VISIBLE);
        } else {
            binding.progressLoading.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    protected void setUp(View view) {
        // Carregar o chamado selecionado para apresentação dos dados
        mChamadoDetailsViewModel.findOneByIdChamado(getIdChamado());

//
//        if (find != null)
//        {
//            binding.tvNomeTecnico.setText(find.getNomeTecnico());
//            binding.tvDataAberturaChamado.setText(find.getDataHoraAberturaChamado());
//            binding.tvDataPrevisaoAtendimento.setText(find.getDataPrevisaoAtendimento());
//            binding.tvModalidadeChamado.setText(find.getModalidadeChamado());
//            binding.tvTipoChamado.setText(find.getTipoChamado());
//            binding.tvDefeitoMaquina.setText(find.getDefeitoChamado());
//            binding.tvDefeitoCliente.setText(find.getDefeitoRelatadoCliente());
//            binding.tvClienteChamado.setText(find.getIdCliente() + " - " + find.getNomeCliente());
//            binding.tvEnderecoCliente.setText(find.getEnderecoCliente() + " , " + find.getNumeroEnderecoCliente());
//            binding.tvBairroCliente.setText(find.getBairroCliente() );
//            binding.tvCepCliente.setText(find.getCepCliente());
//            binding.tvCidadeCliente.setText(find.getCidadeCliente());
//            binding.tvUfCliente.setText(find.getUfCliente());
//            binding.tvContatoCliente.setText(find.getContatoCliente());
//            binding.tvFoneCliente.setText(find.getTelefoneCliente());
//            binding.tvEmailCliente.setText(find.getEmailCliente());
//            binding.tvSerieEquipamento.setText(find.getSerieEquipamento());
//            binding.tvPatrimonioEquipamento.setText(find.getPatrimonioEquipamento());
//            binding.tvModeloEquipamento.setText(find.getModeloEquipamento());
//            binding.tvDepartamentoEquipamento.setText(find.getDepartamentoEquipamento());
//            binding.tvLocalInstalacaoEquipamento.setText(find.getLocalInstalacaoEquipamento());
//        }

//        binding.btnIniciarChamado.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                mPresenter.onIniciarChamadoClickListener();
//            }
//        });

//        CurrentChamado currentChamado = CurrentChamado.getInstance();
//        // -- Existe chamado ativo error visualização do chamado atual é diferente do ativo
//        if ( currentChamado.existeChamadoAtivo() && !currentChamado.getIdChamadoAtivo().equals(getIdChamado())) {
//            binding.btnIniciarChamado.setVisibility(View.GONE);
//            binding.clRetomarChamado.setVisibility(View.VISIBLE);
//        }
    }

    private Long getIdChamado() {
        return getChamadoSelecionado() != null ? getChamadoSelecionado().getChamadoNumero() : null;
    }

    private ChamadoItemRow getChamadoSelecionado() {
        ChamadoItemRow chamadoSelecionado = null;
        if (getBaseActivity().getIntent().getExtras() != null) {
            chamadoSelecionado = getBaseActivity().getIntent()
                    .getExtras()
                    .getParcelable(AppConstants.CHAMADO_SELECIONADO);
        }
        return chamadoSelecionado;
    }

    @Override
    public void openChamadoActivity() {
        if (!isNetworkConnected()) {
            noNetworkConnetedMessage();
            return;
        }

//        LocationRequest mLocationRequest = new LocationRequest();
//        mLocationRequest.setInterval(10000);
//        mLocationRequest.setFastestInterval(5000);
//        mLocationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
//
//        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder()
//                .addLocationRequest(mLocationRequest);
//
//        PendingResult<LocationSettingsResult> result = LocationServices.SettingsApi
//                .checkLocationSettings(mGoogleApiClient, builder.build());

        ChamadoModel chamadoModel = mChamadoDetailsViewModel.getChamadoModel();
        AtendimentoModel atendimentoModel = AtendimentoModel.iniciarNovoAtendimento(chamadoModel);

        if (checkPermission()) {
            FusedLocationProviderClient locationProviderClient = LocationServices.getFusedLocationProviderClient(getBaseActivity());
            locationProviderClient.getLastLocation()
                    .addOnSuccessListener(new OnSuccessListener<Location>() {
                        @Override
                        public void onSuccess(Location lastLocation) {
                            TimelineModel timelineModel = gerarTimeline(lastLocation, atendimentoModel);
                            atendimentoModel.getTimelines().add(timelineModel);
                            //saveTimeline(atendimentoModel);
                            enviarAtendimentoParaPortal(atendimentoModel);
                        }
                    }).addOnFailureListener(new OnFailureListener() {
                        @Override
                        public void onFailure(@NonNull Exception e) {
                            showDialogErroInterno();
                            LoggerUtils.error(e, this.getClass().getSimpleName());
                        }
                    });
        }

        //TODO IMPLEMENTAR
//        updateChamadoAtivo();
//        Intent startIntent = getBaseActivity().openActivity(ChamadoManutencaoActivityJava.class);
//        startActivity(startIntent);
//        getBaseActivity().finish();
    }

    @NotNull
    private TimelineModel gerarTimeline(Location lastLocation, AtendimentoModel atendimentoModel) {
        TimelineModel timelineModel = TimelineModel.iniciarNovoAtendimento(atendimentoModel);
        timelineModel.setLocationCapture(getLocationCapture(lastLocation));
        return timelineModel;
    }

    @org.jetbrains.annotations.Nullable
    private LocationCapture getLocationCapture(Location lastLocation) {
        LocationCapture locationCapture = null;
        if (lastLocation != null) {
            LoggerUtils.d("Location = " + lastLocation);
            Address address = GeocoderUtils.getAddress(lastLocation.getLatitude(), lastLocation.getLongitude(), getBaseActivity());
            if (address != null) {
                LoggerUtils.d("Addres = " + address);
                locationCapture = new LocationCapture(address);
            }
        } else {
            locationCapture = new LocationCapture(false);
        }
        return locationCapture;
    }

//    private void saveTimeline(AtendimentoModel atendimentoModel) {
//        mChamadoDetailsViewModel.salvarAtendimentoDatabase(atendimentoModel);
//    }

    public boolean checkPermission() {
        return checkPermissionLocation();
    }

    @Override
    public void verificarPermissoes() {
        Dexter.withActivity(getBaseActivity())
                .withPermission(Manifest.permission.ACCESS_FINE_LOCATION)
                .withListener(new PermissionListener() {
                    @Override
                    public void onPermissionGranted(PermissionGrantedResponse response) {
                        mPresenter.onIniciarChamadoClickListener();
                    }

                    @Override
                    public void onPermissionDenied(PermissionDeniedResponse response) {
                        if (response.isPermanentlyDenied()) {
                            getBaseActivity().showSettingsDialogLocalidade();
                        } else {
                            getBaseActivity().showDialogPermissaoLocalidade();
                        }
                    }

                    @Override
                    public void onPermissionRationaleShouldBeShown(PermissionRequest permission, PermissionToken token) {
                        token.continuePermissionRequest();
                    }
                })
                .withErrorListener(error -> {
                    getBaseActivity().showDialogErroInterno();
                    LoggerUtils.d("Dexter", "There was an error: " + error.toString());
                })
                .check();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onDestroyView() {
        mPresenter.onDetach();
        compositeDisposable.dispose();
        super.onDestroyView();
    }

}
