package br.com.softilux.softiluxapp.ui.main;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import br.com.softilux.core.base.AbstractBaseViewHolder;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.ItemAtendimentoRowBinding;

/**
 * Created by Vinicius on 14,Fevereiro,2019
 */
public class AtendimentoChamadoAdapter extends RecyclerView.Adapter<AtendimentoChamadoAdapter.AtendimentoViewHolder> {

    private Context mContext;
    private List<AtendimentoItemRow> mDataSet;
    private OnAtendimentoClickListener mListener;

    public AtendimentoChamadoAdapter(Context context,
                                     List<AtendimentoItemRow> atendimentos,
                                     OnAtendimentoClickListener onAtendimentoClickListener) {
        mContext = context;
        mDataSet = atendimentos;
        mListener = onAtendimentoClickListener;
    }

    @NonNull
    @Override
    public AtendimentoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        LayoutInflater inflater = LayoutInflater.from(mContext);
        ItemAtendimentoRowBinding inflate = DataBindingUtil.inflate(inflater, R.layout.item_atendimento_row, parent, false);
        return new AtendimentoViewHolder(inflate);
    }

    @Override
    public void onBindViewHolder(@NonNull AtendimentoViewHolder atendimentoViewHolder, int position) {
        atendimentoViewHolder.bindData(mDataSet.get(position));
    }

    @Override
    public int getItemCount() {
        return mDataSet.size();
    }

    public void addNewItens(List<AtendimentoItemRow> atendimentosList) {
        mDataSet.addAll(atendimentosList);
        notifyDataSetChanged();
    }

    public void addNewItem(AtendimentoItemRow atendimento) {
        mDataSet.add(atendimento);
        notifyItemInserted(mDataSet.size() - 1);
    }

    public class AtendimentoViewHolder extends AbstractBaseViewHolder<AtendimentoItemRow> {
        private final ItemAtendimentoRowBinding binding;

        public AtendimentoViewHolder(ItemAtendimentoRowBinding rowBinding) {
            super(rowBinding.getRoot());
            this.binding = rowBinding;
        }

        @Override
        public void bindData(AtendimentoItemRow model) {
            super.bindData(model);
            binding.getRoot().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mListener.onAtendimentoItemClick(model);
                }
            });

            binding.tvDataAtendimento.setText(new SimpleDateFormat("dd/MM/yyyy", new Locale("pt", "BR")).format(model.getDataAtendimento()));
            binding.tvAtendimentoNumero.setText(model.getIdAtendimentoAsString());
        }
    }
}
