package br.com.softilux.softiluxapp.ui.login

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import br.com.softilux.core.utils.CommonUtils
import br.com.softilux.core.utils.dialogs.DialogsManager
import br.com.softilux.core.utils.dialogs.ServerErrorDialogFragment
import br.com.softilux.core.webservice.ApiResponse
import br.com.softilux.core.utils.loading.Status
import br.com.softilux.softiluxapp.R
import br.com.softilux.softiluxapp.di.presentation.ViewModelFactory
import br.com.softilux.softiluxapp.transfer.datatransfer.UserResponse
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity
import br.com.softilux.softiluxapp.ui.main.MainActivity3
import br.com.softilux.softiluxapp.ui.permissao.PermissaoActivity
import kotlinx.android.synthetic.main.activity_login.*
import org.apache.commons.lang3.StringUtils
import javax.inject.Inject

class LoginActivity : AbstractBaseActivity() , LoginMvpView {

    @Inject
    lateinit var mPresenter : LoginMvpPresenter<LoginMvpView>

    @Inject
    lateinit var viewModelFactory : ViewModelFactory

    private var loginViewModel : LoginViewModel? = null

    @Inject
    lateinit var mDialogsManager: DialogsManager

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_login)
        activityComponent.inject(this)
        mPresenter.onAttach(this)
        loginViewModel = ViewModelProviders.of(this, viewModelFactory).get(LoginViewModel::class.java)
        registerObservers()
    }

    companion object {
        @JvmStatic
        fun getStartIntent(context: Context): Intent {
            return Intent(context, LoginActivity::class.java)
        }
    }

    override fun openMainActivity() {
        val intent = openActivity(MainActivity3::class.java);
        startActivity(intent)
        finish()
    }

    fun onServerLoginClick(v: View) {
        //Esconde o keyboard
        super.hideKeyboard()

        if (!isNetworkConnected) {
            noNetworkConnetedMessage()
            return
        }
        //Verificar se usuario e email da tela são válidos

        if (isValid()) {
            val loginDTO = LoginDTO(et_email.text.toString(), et_password.text.toString())
            loginViewModel?.loginWebService(loginDTO)
        }

    }

    private fun isValid(): Boolean {
        if (TextUtils.isEmpty(et_email.text)) {
            toastyNormal(resources.getString(R.string.enter_email))
            return false
        }

        if (!CommonUtils.isEmailValid(et_email.text.toString())) {
            toastyNormal(resources.getString(R.string.enter_valid_email))
            return false
        }

        if (TextUtils.isEmpty(et_password.text)) {
            toastyNormal(resources.getString(R.string.enter_password))
            return false
        }

        return true
    }

    private fun registerObservers() {
        loginViewModel?.progressLogin?.observe(this, Observer<ApiResponse<UserResponse>> {
            when(it?.status) {
                Status.LOADING -> {
                    mPresenter.progressView(true)
                }
                Status.ERROR -> {
                    mPresenter.progressView(false)
                    mDialogsManager.showRetainedDialogWithId(ServerErrorDialogFragment.newInstance(), "")
                }
                Status.ERRORBODY -> {
                    mPresenter.progressView(false)
                    val messageToUI = it.response?.message
                    if (StringUtils.isNotBlank(messageToUI))
                        toastyNormal(messageToUI)
                }
                Status.SUCCESS -> {
                    mPresenter.loginSuccess()
                }
                Status.COMPLETED -> {
                    mPresenter.loginSuccess()
                }
            }
        })
    }

    override fun setUp() {

    }

    override fun onDestroy() {
        mPresenter.progressView(false)
        mPresenter.onDetach()
        super.onDestroy()
    }

}