package br.com.softilux.softiluxapp.ui.filter.chamado;

import android.os.Parcel;
import android.os.Parcelable;

import java.io.Serializable;

/**
 * Created by Vinicius on 04,Fevereiro,2019
 */
public class ClienteParcel implements Parcelable {

    private Long id;

    private String nome;

    public ClienteParcel(Long id, String nome) {
        this.id = id;
        this.nome = nome;
    }

    protected ClienteParcel(Parcel in) {
        if (in.readByte() == 0) {
            id = null;
        } else {
            id = in.readLong();
        }
        nome = in.readString();
    }

    public static final Creator<ClienteParcel> CREATOR = new Creator<ClienteParcel>() {
        @Override
        public ClienteParcel createFromParcel(Parcel in) {
            return new ClienteParcel(in);
        }

        @Override
        public ClienteParcel[] newArray(int size) {
            return new ClienteParcel[size];
        }
    };

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (id == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeLong(id);
        }
        dest.writeString(nome);
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder();
        if (this.getId() != -1L) {
            toString.append(this.getId())
                    .append(" - ");
        }
        toString.append(this.getNome());

        return toString.toString();
    }
}
