package br.com.softilux.softiluxapp.ui.filter.chamado;

import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.ChamadoFilterModel;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.data.nosql.IPaperBook;
import br.com.softilux.softiluxapp.databinding.ActivityChamadoFilterBinding;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.core.utils.constants.AppConstants;
import io.paperdb.Paper;

/**
 * Created by Vinicius on 30,Janeiro,2019
 */
public class ChamadoFilterActivity extends AbstractBaseActivity {

    ActivityChamadoFilterBinding binding;

    ChamadoFilterModel chamadoFilter;

    @Inject
    IPaperBook iPaperBook;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_chamado_filter);
        getActivityComponent().inject(this);
        setUp();
        configExtrasParams();
        applyParams(savedInstanceState);
    }

    @Override
    protected void setUp() {
        // Configurar toolbar
        setSupportActionBar(binding.toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(Boolean.TRUE);
            getSupportActionBar().setHomeAsUpIndicator(R.drawable.ic_close_white_24dp);
        }

        // Adapter dos nomes dos clientes
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this,
                android.R.layout.simple_dropdown_item_1line,
                iPaperBook.getNomesClientesAsArray());

        binding.actvNomeCliente.setAdapter(adapter);

        // Adapter dos status disponiveis para filtrar
        ArrayAdapter<String> adapterStatus = new ArrayAdapter<>(this,
                android.R.layout.simple_dropdown_item_1line,
                getResources().getStringArray(R.array.filtro_status_atendimento));

        binding.spnStatusAtendimento.setAdapter(adapterStatus);

        // Limpar formulario de filtro
        binding.btnLimparFiltros.setOnClickListener(v -> clearForm());
    }

    private void clearForm() {
        chamadoFilter = null;
        binding.actvNomeCliente.setText("");
        binding.spnStatusAtendimento.setSelection(0);
        binding.etEquipamentoSerie.setText("");
        binding.etChamadoWeb.setText("");
        binding.etChamadoSistema.setText("");
    }

    private void applyParams(Bundle savedInstanceState) {
        if (savedInstanceState == null && chamadoFilter != null) {
            updateUI();
        }
    }

    private void updateUI() {
        if (chamadoFilter.isSerieEquipamentoInformada())
            binding.etEquipamentoSerie.setText(chamadoFilter.getSerieEquipamento());

        if (chamadoFilter.isStatusChamadoInformado()) {
            int position = getIndexOfStatus();
            binding.spnStatusAtendimento.setSelection(position);
        }

        if (chamadoFilter.isNomeClienteInformado())
            binding.actvNomeCliente.setText(chamadoFilter.getNomeCliente());

        if (chamadoFilter.isNumeroChamadoSistemaInformado())
            binding.etChamadoSistema.setText(String.valueOf(chamadoFilter.getNumeroChamadoSistema()));

        if (chamadoFilter.isNumeroChamadoWebInformado())
            binding.etChamadoWeb.setText(String.valueOf(chamadoFilter.getNumeroChamadoWeb()));

    }

    private int getIndexOfStatus() {
        if (StringUtils.isNotBlank(chamadoFilter.getStatusChamado())) {
            List<String> statusArray = getStatusArray();
            for (String status : statusArray) {
                StatusChamado anEnum = StatusChamado.getEnumFromStatus(status);
                if (anEnum != null && anEnum.getStatus().equals(chamadoFilter.getStatusChamado())) {
                    return statusArray.indexOf(status);
                }
            }
        }
        return 0;
    }

    private List<String> getStatusArray() {
        String[] stringArray = getResources().getStringArray(R.array.filtro_status_atendimento);
        return Arrays.asList(stringArray);
    }

    private void configExtrasParams() {
        Intent intent = getIntent();
        if (intent.hasExtra(AppConstants.FILTER_CHAMADO)) {
            chamadoFilter = intent.getParcelableExtra(AppConstants.FILTER_CHAMADO);
        }
    }

    public static Intent getStartIntent(Context context) {
        return new Intent(context, ChamadoFilterActivity.class);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        getMenuInflater().inflate(R.menu.menu_chamado_filter, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_apply_filter:
                Intent resultIntent = new Intent();
                resultIntent.putExtra(AppConstants.FILTER_CHAMADO, getResultExtraFilter());
                setResult(RESULT_OK, resultIntent);
                finish();
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private ChamadoFilterModel getResultExtraFilter() {
        ChamadoFilterModel filter = new ChamadoFilterModel();

        if (binding.spnStatusAtendimento.getSelectedItemPosition() > 0)
            filter.setStatusChamado((String) binding.spnStatusAtendimento.getSelectedItem());
        if (!TextUtils.isEmpty(binding.actvNomeCliente.getText()))
            filter.setNomeCliente(binding.actvNomeCliente.getText().toString());
        if (!TextUtils.isEmpty(binding.etChamadoSistema.getText()))
            filter.setNumeroChamadoSistema(Long.parseLong(binding.etChamadoSistema.getText().toString()));
        if (!TextUtils.isEmpty(binding.etChamadoWeb.getText()))
            filter.setNumeroChamadoWeb(Long.parseLong(binding.etChamadoWeb.getText().toString()));
        if (!TextUtils.isEmpty(binding.etEquipamentoSerie.getText()))
            filter.setSerieEquipamento(binding.etEquipamentoSerie.getText().toString());

        return filter;
    }

}
