package br.com.softilux.softiluxapp.ui.chamado.solicitacoes;

import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import org.apache.commons.collections4.CollectionUtils;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.databinding.FragmentSolicitacoesBinding;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseFragment;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.softiluxapp.ui.chamado.CurrentChamado;
import br.com.softilux.softiluxapp.ui.solicitacoes.NovaSolicitacaoActivity;
import br.com.softilux.softiluxapp.ui.solicitacoes.NovaSolicitacaoAdapter;
import br.com.softilux.softiluxapp.ui.solicitacoes.SolicitacaoClickListener;
import br.com.softilux.softiluxapp.ui.solicitacoes.SolicitacaoPecaModel;

/**
 * Created by Vinicius on 05,Fevereiro,2019
 */
public class SolicitacoesPecasFragment extends AbstractBaseFragment implements SolicitacoesMvpView,
        View.OnClickListener {

    @Inject
    SolicitacoesMvpPresenter<SolicitacoesMvpView> mPresenter;

    FragmentSolicitacoesBinding binding;

    public static SolicitacoesPecasFragment newInstance() {
        return new SolicitacoesPecasFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_solicitacoes, container, false);

        PresentationComponent component = getActivityComponent();
        if (component != null) {
            component.inject(this);
            mPresenter.onAttach(this);
        }

        return binding.getRoot();
    }

    @Override
    protected void setUp(View view) {
        binding.fabNewCollect.setOnClickListener(this);

    }

    @Override
    public void onResume() {
        super.onResume();

        //ChamadosStatic currentChamado = CurrentChamado.getInstance().getCurrentChamado();
        AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();
        // -- Verificar se existe solicitações de pecas
        if (CollectionUtils.isNotEmpty(currentAtendimentoChamado.getPecasSolicitadas())) {
            binding.rvMainColetas.setVisibility(View.VISIBLE);
            binding.cvShowRvEmpty.setVisibility(View.GONE);

            binding.rvMainColetas.setLayoutManager(new LinearLayoutManager(getContext()));
            binding.rvMainColetas.setHasFixedSize(true);
            NovaSolicitacaoAdapter novaSolicitacaoAdapter = new NovaSolicitacaoAdapter(getContext(), currentAtendimentoChamado.getPecasSolicitadas(), new SolicitacaoClickListener() {
                @Override
                public void onItemClick(SolicitacaoPecaModel solicitacaoPecaModel) {
                    // --
                }
            });
            binding.rvMainColetas.setAdapter(novaSolicitacaoAdapter);
        } else {
            binding.rvMainColetas.setVisibility(View.GONE);
            binding.cvShowRvEmpty.setVisibility(View.VISIBLE);
        }

    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.fab_new_collect) {
            mPresenter.onNovaSolicitacaoClickListener();
        }
    }

    @Override
    public void openNovaSolicitacaoActivity() {
        Intent startIntent = NovaSolicitacaoActivity.getStartIntent(getActivity());
        getBaseActivity().startActivity(startIntent);
    }

    @Override
    public void onDestroyView() {
        mPresenter.onDetach();
        super.onDestroyView();
    }

}
