package br.com.softilux.softiluxapp.ui.chamado.pausar;


import javax.inject.Inject;

import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class PausarChamadoDialogPresenter<V extends PausarChamadoDialogMvpView> extends BasePresenter<V>
        implements PausarChamadoDialogMvpPresenter<V> {

    @Inject
    public PausarChamadoDialogPresenter(DataManager dataManager,
                                 SchedulerProvider schedulerProvider,
                                 CompositeDisposable compositeDisposable,
                                        ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable, configDAO);
    }

    @Override
    public void onClickCancelarPausa() {
        getMvpView().dismissDialog();
    }

    @Override
    public void onClickContinuarPausa() {
        getMvpView().dismissDialog();
    }
}
