package br.com.softilux.softiluxapp.ui.chamado.pausar

import android.app.Activity
import android.content.Context
import android.os.Bundle
import android.support.v4.app.FragmentManager
import android.support.v7.widget.DividerItemDecoration
import android.support.v7.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.inputmethod.InputMethodManager
import br.com.softilux.softiluxapp.R
import br.com.softilux.softiluxapp.ui.base.AbstractBaseDialog
import kotlinx.android.synthetic.main.dialog_pausar_chamado.*
import javax.inject.Inject


/**
 * Created by Vinicius on 05,Janeiro,2019
 */

class PausarChamadoDialog : AbstractBaseDialog(), PausarChamadoDialogMvpView, View.OnClickListener {

    @Inject
    lateinit var mPresenter: PausarChamadoDialogMvpPresenter<PausarChamadoDialogMvpView>

    private val TAG = "PausarChamadoDialog"

    interface EditNameDialogListener {
        fun onFinishEditDialog(isSuccess: Boolean ,inputText: String)
    }

    companion object {
        @JvmStatic
        fun newInstance(): PausarChamadoDialog {
            return PausarChamadoDialog()
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val view = inflater.inflate(R.layout.dialog_pausar_chamado, container, false)

        val component = activityComponent
        if (component != null) {
            component.inject(this)
            mPresenter.onAttach(this)
        }
        return view
    }

    fun show(fragmentManager: FragmentManager) {
        super.show(fragmentManager, TAG)
    }

    override fun setUp(view: View?) {
        btn_later.setOnClickListener(this)
        btn_submit.setOnClickListener(this)

        val opcoes = arrayListOf(OffersModel(1L, "Refeição"),
                OffersModel(2L, "Falta de energia"),
                OffersModel(3L, "Buscar Ferramentas"),
                OffersModel(4L, "Indisponibilidade do cliente"),
                OffersModel(5L, "Outros..."))

        val recyclerLayoutManager = LinearLayoutManager(context)
        rv_options.layoutManager = recyclerLayoutManager

        val dividerItemDecoration = DividerItemDecoration(rv_options.context,
                recyclerLayoutManager.orientation)
        rv_options.addItemDecoration(dividerItemDecoration)


        //val recyclerViewAdapter = OffersRecyclerViewAdapter(opcoes, context, this)
        //rv_options.adapter = recyclerViewAdapter


        //dialog.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE)
    }

    override fun dismissDialog() {
        super.dismissDialog(TAG)
    }

    override fun onClick(v: View?) {
//        when (v?.id) {
//            btn_later.id -> {
//                hideKeyboardFrom(context!!, btn_later)
//                (activity as ChamadoManutencaoActivity).onFinishEditDialog(false , "")
//                mPresenter.onClickCancelarPausa()
//            }
//            btn_submit.id -> {
//                hideKeyboardFrom(context!!, btn_submit)
//                var toString = ""
//                //textArea_information?.text?.let { toString = it.toString() }
//                (activity as ChamadoManutencaoActivity).onFinishEditDialog(true , toString)
//                mPresenter.onClickContinuarPausa()
//            }
//        }
    }

    fun hideKeyboardFrom(context: Context, view: View) {
        val imm = context.getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.hideSoftInputFromWindow(view.windowToken, 0)
    }

    override fun onDestroyView() {
        mPresenter.onDetach()
        super.onDestroyView()
    }

}