package br.com.softilux.softiluxapp.ui.chamado.pausar;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import java.util.List;

import br.com.softilux.softiluxapp.R;

public class OffersRecyclerViewAdapter extends RecyclerView.Adapter<OffersRecyclerViewAdapter.PausarHolder> {

    private List<OffersModel> offersList;
    private Context mContext;
    private OnMotivoClickListener onMotivoClickListener;
    private int lastSelectedPosition = 0;

    public OffersRecyclerViewAdapter(List<OffersModel> offersListIn,Context mContext, OnMotivoClickListener onMotivoClickListener) {
        this.offersList = offersListIn;
        this.mContext = mContext;
        this.onMotivoClickListener = onMotivoClickListener;
    }

    @NonNull
    @Override
    public PausarHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_opcao_pausa, parent, false);
        return new PausarHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull PausarHolder holder, int position) {
        OffersModel offersModel = offersList.get(position);
        holder.offerName.setText(offersModel.getTexto());
        //since only one radio button is allowed to be selected,
        // this condition un-checks previous selections
        holder.selectionState.setChecked(lastSelectedPosition == position);
    }

    @Override
    public int getItemCount() {
        return offersList.size();
    }

    public String getTextOfSelectionItem() {
        return offersList.get(lastSelectedPosition).getTexto();
    }

    public class PausarHolder extends RecyclerView.ViewHolder {

        TextView offerName;
        RadioButton selectionState;

        PausarHolder(View view) {
            super(view);
            offerName = view.findViewById(R.id.offer_name);
            selectionState = view.findViewById(R.id.offer_select);

            selectionState.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    lastSelectedPosition = getAdapterPosition();
                    onMotivoClickListener.onItemClick(offersList.get(getAdapterPosition()));
                    notifyDataSetChanged();
                }
            });
        }
    }
}
