package br.com.softilux.softiluxapp.ui.chamado.imagens;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.SolicitacoesMvpPresenter;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.SolicitacoesMvpView;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class ImagensChamadoPresenter<V extends ImagensChamadoMvpView> extends BasePresenter<V>
        implements ImagensChamadoMvpPresenter<V> {

    @Inject
    public ImagensChamadoPresenter(DataManager dataManager,
                                 SchedulerProvider schedulerProvider,
                                 CompositeDisposable compositeDisposable,
                                   ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable, configDAO);
    }

    @Override
    public void onNovaImagemClickListener() {
        getMvpView().openPicture();
    }

    @Override
    public void showFiles(boolean show) {
        getMvpView().showFiles(show);
    }

    @Override
    public void createDialogChooseOptionsTakePicture() {
        getMvpView().createDialogChooseOptionsTakePicture();
    }
}
