package br.com.softilux.softiluxapp.ui.chamado.imagens;

import android.Manifest;
import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.databinding.DataBindingUtil;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.karumi.dexter.Dexter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.DexterError;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.PermissionRequestErrorListener;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;

import org.apache.commons.collections4.CollectionUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.inject.Inject;

import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.BuildConfig;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.dao.AmazonPhotoDAO;
import br.com.softilux.softiluxapp.data.db.model.AmazonFileModel;
import br.com.softilux.softiluxapp.data.db.model.AmazonPhotoViewHolder;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.representation.TipoFoto;
import br.com.softilux.softiluxapp.databinding.FragmentImagensChamadoBinding;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.transfer.services.IFileService;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseFragment;
import br.com.softilux.softiluxapp.utils.PermissaoUtils;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import es.dmoral.toasty.Toasty;
import io.reactivex.disposables.CompositeDisposable;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class ImagensChamadoFragment extends AbstractBaseFragment implements ImagensChamadoMvpView, View.OnClickListener, ImagemClickListener {

    @Inject
    ImagensChamadoMvpPresenter<ImagensChamadoMvpView> mPresenter;

    @Inject
    CompositeDisposable compositeDisposable;

    @Inject
    SchedulerProvider schedulerProvider;

    @Inject
    IFileService mFileService;

    @Inject
    AmazonPhotoDAO mAmazonPhotoDAO;

    private final int CODE = 15;

    private FragmentImagensChamadoBinding binding;

    String mCurrentPhotoPath;

    Uri mCurrentPhotoUri = null;

    /**
     * Adapter dos chamados exibidos na ui
     * */
    private ImagemAdapterJava mImagemAdapter;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_imagens_chamado, container, false);
        // Inject dependencies
        PresentationComponent activityComponent = getActivityComponent();
        if (activityComponent != null) {
            getActivityComponent().inject(this);
            mPresenter.onAttach(this);
        }
        return binding.getRoot();
    }

    public static ImagensChamadoFragment newInstance() {
        return new ImagensChamadoFragment();
    }

    @Override
    protected void setUp(View view) {
        // Configurar acao de click do botão
        binding.fabNovoArquivo.setOnClickListener(this);
        // Configurar recycler view
        binding.rvMainFotos.setLayoutManager(new LinearLayoutManager(getBaseActivity()));
        binding.rvMainFotos.setHasFixedSize(true);
        mImagemAdapter = new ImagemAdapterJava(getContext(), new ArrayList<>(), this);
        mImagemAdapter.setHasStableIds(true);
        binding.rvMainFotos.setAdapter(mImagemAdapter);

        // Processar as fotos ja cadastradas no atendimento
        AtendimentoModel atendimentoModel = getCurrentChamadoAtendimento().getAtendimentoModel();
        if ( CollectionUtils.isNotEmpty(atendimentoModel.getPhotos()) ) {
            atendimentoModel.getPhotos().forEach(photo -> {
                AmazonPhotoViewHolder amazonPhotoViewHolder = convertToViewHolder(photo);
                mImagemAdapter.addItem(amazonPhotoViewHolder);
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
//        AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();
//        // -- Verificar se existe solicitações de pecas
//        if (CollectionUtils.isNotEmpty(currentAtendimentoChamado.getFotosEquipamento())) {
//            // Show recycler view and hide card
//            showFiles(true);
//            // Configurar recycler view
////            binding.rvMainFotos.setLayoutManager(new LinearLayoutManager(getContext()));
////            binding.rvMainFotos.setHasFixedSize(true);
//            ImagemAdapterJava imagemAdapterJava = new ImagemAdapterJava(getContext(),
//                    new ArrayList<>(currentAtendimentoChamado.getFotosEquipamento()),
//                    ImagensChamadoFragment.this);
//            binding.rvMainFotos.setAdapter(imagemAdapterJava);
//        } else {
//            // Show card view and hide recycler
//            mPresenter.showFiles(false);
//        }
    }

    @Override
    public void showFiles(boolean show) {
        if ( show ) {
            binding.rvMainFotos.setVisibility(View.VISIBLE);
            binding.cvShowRvEmpty.setVisibility(View.GONE);
        } else {
            binding.rvMainFotos.setVisibility(View.GONE);
            binding.cvShowRvEmpty.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void openPicture() {
        //Intent photoPickerIntent = new Intent(Intent.ACTION_GET_CONTENT);
        Intent photoPickerIntent = new Intent(Intent.ACTION_PICK);
        photoPickerIntent.setType("image/*"); //allows any image file type. Change * to specific extension to limit it
        //intent.putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true);
        //startActivityForResult(Intent.createChooser(intent, "Selecionar Imagem"), CODE);
        startActivityForResult(photoPickerIntent, CODE);
    }

    private File createImageFile() throws IOException {
        // Create an image file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", new Locale("pt", "BR")).format(new Date());
        String imageFileName = "jpg_" + timeStamp + "_";
        File storageDir = getBaseActivity().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        LoggerUtils.info("Nova imagem: " + imageFileName);
        LoggerUtils.info("Tempo: "+timeStamp);
        File image = File.createTempFile(
                imageFileName,  /* prefix */
                ".jpg",         /* suffix */
                storageDir      /* directory */
        );

        LoggerUtils.info(image != null ? "imagem nao esta vazia" : "imagem vazia");
        // Save a file: path for use with ACTION_VIEW intents
        mCurrentPhotoPath = image.getAbsolutePath();
        LoggerUtils.info("Absolute path: " + mCurrentPhotoPath);

        return image;
    }

    private void alertValidatePermission() {
        AlertDialog.Builder builder = new AlertDialog.Builder(getBaseActivity(), R.style.AlertDialogTheme);
        builder.setTitle("Permissão Negada");
        builder.setMessage("Para informar uma foto é necessario aceitar as permissões");
        builder.setPositiveButton("Confirmar", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public String getPath(Uri uri)
    {
        String[] projection = { MediaStore.Images.Media.DATA };
        Cursor cursor = getBaseActivity().getContentResolver().query(uri, projection, null, null, null);
        if (cursor == null) return null;
        int column_index =             cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
        cursor.moveToFirst();
        String s=cursor.getString(column_index);
        cursor.close();
        return s;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        //AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();
        if (requestCode == CODE) {
            LoggerUtils.info(resultCode == Activity.RESULT_OK ? "result_ok" :"result_not_ok");
            if (Activity.RESULT_OK == resultCode && data != null) {
                if (data.getClipData() != null) {
                    LoggerUtils.info("Tem clipData");
                    Uri uri = data.getClipData().getItemAt(0).getUri();
                    LoggerUtils.info("" + uri);
                    File image = getFileFromUri(uri);
                    if (image != null) {
                        sincronizePhotoWithServer(image);
                    } else {
                        showDialogErroInterno();
                    }
                } else if (data.getData() != null) {
                    LoggerUtils.info("Tem data");
                    Uri uri = data.getData();
                    File image = getFileFromUri(uri);
                    if (image != null) {
                        sincronizePhotoWithServer(image);
                    } else {
                        showDialogErroInterno();
                    }
                }
            }
        } else if (requestCode == PermissaoUtils.REQUEST_CAMERA && resultCode == Activity.RESULT_OK ) {
            sincronizePhotoWithServer(new File(mCurrentPhotoPath));
        }

        //CurrentChamado.getInstance().getCurrentChamado().updateAtendimento(currentAtendimentoChamado);
    }

    @org.jetbrains.annotations.Nullable
    private File getFileFromUri(Uri uri) {
        InputStream in = null;
        try {
             in = getBaseActivity().getContentResolver().openInputStream(uri);
        } catch (FileNotFoundException e) {
            LoggerUtils.info(e, "");
        }

        OutputStream out;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", new Locale("pt", "BR")).format(new Date());
        String imageFileName = "jpg_" + timeStamp + "_";
        File storageDir = getBaseActivity().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        LoggerUtils.info("Nova imagem: " + imageFileName);
        LoggerUtils.info("Tempo: "+timeStamp);
        File image = null;
        try {
            image = File.createTempFile(
                    imageFileName,  /* prefix */
                    ".jpg",         /* suffix */
                    storageDir      /* directory */
            );
            out = new FileOutputStream(image);
            byte[] buf = new byte[1024];
            int len;
            if (in != null) {
                while((len=in.read(buf))>0){
                    out.write(buf,0,len);
                }
                in.close();
            }
            out.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    @Override
    public void onClick(View clickedView) {
        if (clickedView.getId() == binding.fabNovoArquivo.getId()) {
            // Create choose options
            mPresenter.createDialogChooseOptionsTakePicture();
        }
    }

    @Override
    public void createDialogChooseOptionsTakePicture() {
        //Options
        final CharSequence[] items = {"Camera", "Galeria", "Cancelar"};
        AlertDialog.Builder builder = new AlertDialog.Builder(getBaseActivity(), R.style.MyDialog);
        builder.setTitle(Html.fromHtml("<b>Escolha a opção</b>"));
        builder.setItems(items, (dialog, which) -> {
            if (!podeFazerUploadAmazon() && !"Cancelar".equals(items[which])){
                dialog.dismiss();
                Toasty.normal(getBaseActivity(), "Você não pode informar mais do que 5 imagens no atendimento.", Toasty.LENGTH_SHORT).show();
                return;
            }

            if (!isNetworkConnected()) {
                dialog.dismiss();
                noNetworkConnetedMessage();
                return;
            }

            if ("Camera".equals(items[which])) {
                showCamera();
            } else if("Galeria".equals(items[which])) {
                verificarPermissoesStorage();
            } else if("Cancelar".equals(items[which])) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private void verificarPermissoesStorage() {
        Dexter.withActivity(getBaseActivity())
                .withPermissions(Manifest.permission.READ_EXTERNAL_STORAGE)
                .withListener(new MultiplePermissionsListener() {
                    @Override
                    public void onPermissionsChecked(MultiplePermissionsReport report) {
                        if (report.isAnyPermissionPermanentlyDenied()) {
                            showSettingsDialogStorage();
                        } else if (report.areAllPermissionsGranted()) {
                            mPresenter.onNovaImagemClickListener();
                        } else {
                            getBaseActivity().showDialogPermissaoStorage();
                        }
                    }
                    @Override
                    public void onPermissionRationaleShouldBeShown(List<PermissionRequest> permissions, PermissionToken token) {
                        token.continuePermissionRequest();
                    }
                })
                .withErrorListener(new PermissionRequestErrorListener() {
                    @Override
                    public void onError(DexterError error) {
                        getBaseActivity().showDialogErroInterno();
                        LoggerUtils.d("Dexter verificarPermissoesStorage() ", "There was an error: " + error.toString());
                    }
                })
                .check();
    }

    private void showCamera() {
        Dexter.withActivity(getBaseActivity())
                .withPermissions(Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                .withListener(new MultiplePermissionsListener() {
                    @Override
                    public void onPermissionsChecked(MultiplePermissionsReport report) {
                        if (report.isAnyPermissionPermanentlyDenied()) {
                            showSettingsDialogCamera();
                        } else if (report.areAllPermissionsGranted()) {
                            dispatchTakePictureIntent();
                        } else {
                            getBaseActivity().showDialogPermissaoCamera();
                        }
                    }

                    @Override
                    public void onPermissionRationaleShouldBeShown(List<PermissionRequest> permissions, PermissionToken token) {
                        token.continuePermissionRequest();
                    }
                })
                .withErrorListener(new PermissionRequestErrorListener() {
                    @Override
                    public void onError(DexterError error) {
                        getBaseActivity().showDialogErroInterno();
                        LoggerUtils.d("Dexter showCamera() ", "There was an error: " + error.toString());
                    }
                })
                .check();


//        // Verifiy camera permission is granted
//        if (getBaseActivity().checkSelfPermission(Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED) {
//            // Take picture and show in view
//            dispatchTakePictureIntent();
//        } else {
//            //Verify permissions camera
//            if (shouldShowRequestPermissionRationale(Manifest.permission.CAMERA)) {
//                // Start alert
//            } else {
//                // Request permissions
//                requestPermissions(PermissaoUtils.PERMISSION_CAMERA, PermissaoUtils.REQUEST_CAMERA);
//            }
//        }
    }

    public void showSettingsDialogCamera() {
        android.support.v7.app.AlertDialog.Builder builder = new android.support.v7.app.AlertDialog.Builder(getBaseActivity(), R.style.AlertDialogTheme);
        builder.setTitle(getString(R.string.permissao_necessaria));
        builder.setMessage(getString(R.string.permissao_camera_necessaria));
        builder.setPositiveButton("Settings", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                getBaseActivity().openSettings();
            }
        });
        builder.setNegativeButton(getString(R.string.cancelar), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        android.support.v7.app.AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public void showSettingsDialogStorage() {
        android.support.v7.app.AlertDialog.Builder builder = new android.support.v7.app.AlertDialog.Builder(getBaseActivity(), R.style.AlertDialogTheme);
        builder.setTitle(getString(R.string.permissao_necessaria));
        builder.setMessage(getString(R.string.permissao_storage_necessaria));
        builder.setPositiveButton("Settings", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                getBaseActivity().openSettings();
            }
        });
        builder.setNegativeButton(getString(R.string.cancelar), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        android.support.v7.app.AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == PermissaoUtils.REQUEST_CAMERA) {
            if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                // Take picture and show in view
                dispatchTakePictureIntent();
            } else {
                // User not granted permission, show alert
                alertValidatePermission();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private void dispatchTakePictureIntent() {
        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        // Ensure that there's a camera activity to handle the intent
        if (takePictureIntent.resolveActivity(getBaseActivity().getPackageManager()) != null) {
            // Create the File where the photo should go
            File photoFile = null;
            try {
                photoFile = createImageFile();
                LoggerUtils.info(photoFile.getAbsolutePath());
            } catch (IOException ex) {
                // Error occurred while creating the File
                ex.printStackTrace();
                showMessage("Error: " + ex.getMessage());
            }
            // Continue only if the File was successfully created
            if (photoFile != null) {
                mCurrentPhotoUri = FileProvider.getUriForFile(getBaseActivity().getApplicationContext(),
                        BuildConfig.APPLICATION_ID + ".fileprovider",
                        photoFile);
                LoggerUtils.info(mCurrentPhotoUri.getPath());
                takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, mCurrentPhotoUri);
                startActivityForResult(takePictureIntent, PermissaoUtils.REQUEST_CAMERA);
            }
        }
    }

    public void sincronizePhotoWithServer(File file) {

//            MediaStore.Images.Media.insertImage(getBaseActivity().getContentResolver(), file.getAbsolutePath(), file.getName(), null);
//            getBaseActivity().sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, Uri.fromFile(file)));

        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);

    // MultipartBody.Part is used to send also the actual file name
        MultipartBody.Part body = MultipartBody.Part.createFormData("image", file.getName(), requestFile);

        LoggerUtils.info("" + body);

        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();

        AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();

        if (!isNetworkConnected()) {
            noNetworkConnetedMessage();
            return;
        }

        // add another part within the multipart request
        RequestBody tipo = RequestBody.create(MediaType.parse("multipart/form-data"), TipoFoto.FOTO_EQUIPAMENTO.getTipoFoto());


        compositeDisposable.add(mFileService.uploadImage(tipo, body, atendimentoModel.getIdAtendimentoPortal(), atendimentoModel.getIdBase())
                .observeOn(schedulerProvider.ui())
                .subscribeOn(schedulerProvider.io())
                .doOnSubscribe(d -> showLoading())
                .doOnTerminate(this::hideLoading)
                .subscribe(
                        result -> {
                            LoggerUtils.info("Resultado foi: " + result);
                            if (result.hasData()) {
                                AmazonFileModel amazonFileModel = AmazonFileModel.gerarNovoAmazonFileFotoEquipamento(result.getData(), atendimentoModel);
                                LoggerUtils.info("" + amazonFileModel.getTipoFoto());
                                long insert = mAmazonPhotoDAO.insert(amazonFileModel);
                                AmazonFileModel byIdApp = mAmazonPhotoDAO.findByIdApp(insert);
                                atendimentoModel.getPhotos().add(byIdApp);
                                atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
                                AmazonPhotoViewHolder amazonPhotoViewHolder = convertToViewHolder(byIdApp);
                                mImagemAdapter.addItem(amazonPhotoViewHolder);
                            }

                        },
                        throwable ->  {
                            hideLoading();
                            LoggerUtils.error(throwable, this.getClass().getSimpleName());
                            showDialogErroInterno();
                        }
                ));

    }

    private AmazonPhotoViewHolder convertToViewHolder(AmazonFileModel byIdApp) {
        AmazonPhotoViewHolder amazonPhotoViewHolder = new AmazonPhotoViewHolder(byIdApp.getIdApp(),
                byIdApp.getAmazonid() + "/" + byIdApp.getFilename());
        return amazonPhotoViewHolder;
    }

    public boolean podeFazerUploadAmazon() {
        AtendimentoModel atendimentoModel = getCurrentChamadoAtendimento().getAtendimentoModel();
        List<AmazonFileModel> photos = atendimentoModel.getPhotos();

        return CollectionUtils.isEmpty(photos) || photos.size() < 5;
    }

    @Override
    public void onItemClick(String s) {
        // TODO implementar
    }

    @Override
    public void onDestroyView() {
        mPresenter.onDetach();
        compositeDisposable.dispose();
        super.onDestroyView();
    }
}
