package br.com.softilux.softiluxapp.ui.chamado.imagens;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.LazyHeaders;

import java.util.List;

import br.com.softilux.core.base.AbstractBaseViewHolder;
import br.com.softilux.core.base.BaseRecyclerViewItens;
import br.com.softilux.softiluxapp.BuildConfig;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.AmazonPhotoViewHolder;

public class ImagemAdapterJava extends BaseRecyclerViewItens<ImagemAdapterJava.MyViewHolder, AmazonPhotoViewHolder> {

    private Context mContext;
    //private List<Uri> list;
    private ImagemClickListener listener;

    public ImagemAdapterJava(final Context context,
                             //List<Uri> list,
                             List<AmazonPhotoViewHolder> list,
                             final ImagemClickListener listener) {
        super(list);
        this.mContext = context;
       // this.list = list;
        this.listener = listener;
    }

    @NonNull
    @Override
    public ImagemAdapterJava.MyViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View inflate = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_equipamento_row, viewGroup, false);
        return new MyViewHolder(inflate);
    }

//    @Override
//    public void onBindViewHolder(@NonNull AbstractBaseViewHolder<MyViewHolder> myViewHolderBaseViewHolder2, int position) {
//        Uri uri = getItens().get(position);
//        myViewHolderBaseViewHolder2.bindData(uri);
//        Glide.with(mContext).load(uri).into(myViewHolderBaseViewHolder2.f)
//    }


    @Override
    public long getItemId(int position) {
        return getItens().get(position).getId();
    }

    @Override
    public void onBindViewHolder(@NonNull ImagemAdapterJava.MyViewHolder myViewHolder, int position) {
        //Uri uri = getItens().get(position);
        //Glide.with(mContext).load(uri).into(myViewHolder.foto);

        AmazonPhotoViewHolder amazonPhotoViewHolder = getItens().get(position);

        LazyHeaders auth = new LazyHeaders.Builder()
                .addHeader("X-AUTH-TOKEN", "eyJ0eXAiOiJKV1QiLCJhbGciTWvLUzI1NiJ9IiRkYXRhIg")
                .build();

        String url = BuildConfig.REST_SERVER + "api/v1/atendimentos/photo/get?path=" + amazonPhotoViewHolder.getPathName() ;

        GlideUrl urlPhoto = new GlideUrl(url, auth);
        Glide.with(mContext)
            .load(urlPhoto)
            .into(myViewHolder.foto);
    }

    public class MyViewHolder extends AbstractBaseViewHolder<AmazonPhotoViewHolder> {

        public ImageView foto;

        public MyViewHolder(@NonNull View itemView) {
            super(itemView);
            foto = itemView.findViewById(R.id.foto_equipamento);
        }

        @Override
        public void bindData(AmazonPhotoViewHolder model) {
            super.bindData(model);
        }

    }
}
