package br.com.softilux.softiluxapp.ui.chamado.finalizar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.inject.Inject;

import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.databinding.ActivityFinalizarChamadoBinding;
import br.com.softilux.softiluxapp.transfer.datatransfer.CdMedidorResponseDTO;
import br.com.softilux.softiluxapp.transfer.datatransfer.TipoStatusResponseDTO;
import br.com.softilux.softiluxapp.transfer.services.IMedidoresService;
import br.com.softilux.softiluxapp.transfer.services.ITipoStatusService;
import br.com.softilux.softiluxapp.ui.assinatura.AssinaturaActivity;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.AtendimentoChamado;
import br.com.softilux.softiluxapp.ui.chamado.ChamadosStatic;
import br.com.softilux.softiluxapp.ui.chamado.CurrentChamado;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import es.dmoral.toasty.Toasty;
import io.reactivex.disposables.CompositeDisposable;

/**
 * Created by Vinicius on 02,Fevereiro,2019
 */
public class FinalizarChamadoActivity extends AbstractBaseActivity implements FinalizarChamadoMvpView {

    @Inject
    FinalizarChamadoMvpPresenter<FinalizarChamadoMvpView> mPresenter;

    ActivityFinalizarChamadoBinding binding;

    @Inject
    IMedidoresService mMdidoresService;

    @Inject
    ITipoStatusService mTipoStatusService;

    @Inject
    CompositeDisposable mCompositeDisposable;

    @Inject
    SchedulerProvider mSchedulerProvider;

    private String selectedItemText;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_finalizar_chamado);
        getActivityComponent().inject(this);
        mPresenter.onAttach(this);
        setUp();
    }

    public static Intent getStartIntent(Context context) {
        return new Intent(context, FinalizarChamadoActivity.class);
    }

    @SuppressLint("ClickableViewAccessibility")
    @Override
    protected void setUp() {
        ArrayList<String> objects = new ArrayList<>();
        objects.add("Selecionar o medidor");
        objects.add("CORA4");
        objects.add("PBA4");

        ArrayAdapter<String> arrayAdapter2 = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, getResources().getStringArray(R.array.status_chamado));
        binding.spnStatus.setAdapter(arrayAdapter2);
        selectedItemText = StatusChamado.PENDENTE.getStatus();
        binding.spnStatus.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedItemText = (String) parent.getItemAtPosition(position);
                sincronizeTipoStatus();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }

        });

//        ArrayAdapter<String> arrayAdapter3 = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, getResources().getStringArray(R.array.tipo_chamado));
//        binding.spnTipoStatus.setAdapter(arrayAdapter3);

        binding.btnFinalizar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mPresenter.onClickFinalizarChamado();
            }
        });

//        binding.etFollowUp.setOnTouchListener(new View.OnTouchListener() {
//            @Override
//            public boolean onTouch(View v, MotionEvent event) {
//                v.getParent().requestDisallowInterceptTouchEvent(true);
//                switch (event.getAction() & MotionEvent.ACTION_MASK) {
//                    case MotionEvent.ACTION_UP:
//                        v.getParent().requestDisallowInterceptTouchEvent(false);
//                        break;
//                }
//                return false;
//            }
//        });

        Locale mLocale = new Locale("pt", "BR");
        binding.etValorPedagio.addTextChangedListener(new MoneyTextWatcher(binding.etValorPedagio, mLocale));
        binding.etOutrosValores.addTextChangedListener(new MoneyTextWatcher(binding.etOutrosValores, mLocale));
        binding.etValorEstacionamento.addTextChangedListener(new MoneyTextWatcher(binding.etValorEstacionamento, mLocale));

//        mCompositeDisposable.add(mTipoStatusService.list(chamadoModel.getStatusPortal().name(), chamadoModel.getEmpresaId())
//                .observeOn(mSchedulerProvider.ui())
//                .subscribeOn(mSchedulerProvider.io())
//                .subscribe(result -> {
//                    List<TipoStatusResponseDTO> data = result.getData();
//                    LoggerUtils.info("" + data);
//                    if (CollectionUtils.isNotEmpty(data)) {
//                        List<TipoStatusResponseDTO> tipos = new ArrayList<>();
//                        tipos.add(new TipoStatusResponseDTO("Selecione um Status", "-1"));
//                        tipos.addAll(data);
//                        ArrayAdapter<TipoStatusResponseDTO> stringArrayAdapter = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, tipos);
//                        binding.spnTipoStatus.setAdapter(stringArrayAdapter);
//                    }
//                }, throwable -> {
//                    showDialogErroInterno();
//                    LoggerUtils.error(throwable, this.getClass().getSimpleName());
//                })
//        );
        if ( ! isNetworkConnected() ) {
            noNetworkConnetedMessage();
        } else {
            sincronizeMedidores();
            sincronizeTipoStatus();
        }
    }

    private void sincronizeMedidores() {
        ChamadoModel chamadoModel = getCurrentChamadoAtendimento().getChamadoModel();
        mCompositeDisposable.add(mMdidoresService.list(chamadoModel.getCdEquipamento(), chamadoModel.getIdBase())
                .observeOn(mSchedulerProvider.ui())
                .subscribeOn(mSchedulerProvider.io())
                .doOnSubscribe( d -> showLoading())
                .subscribe(result -> {
                    List<CdMedidorResponseDTO> data = result.getData();
                    LoggerUtils.info("" + data);
                    if (CollectionUtils.isNotEmpty(data)) {
                        //List<String> medidores = Arrays.asList("Selecione o Medidor");

                        ArrayList<String> medidores = Stream.of(new String[]{"Selecione o Medidor"}).collect(Collectors.toCollection(ArrayList::new));

                        ArrayList<String> cdsMedidores = data.stream()
                                .map(CdMedidorResponseDTO::getCdmedidor)
                                .collect(Collectors.toCollection(ArrayList::new));
                        medidores.addAll(cdsMedidores);
                        //collect.toArray(String[]::new);
                        ArrayAdapter<String> stringArrayAdapter = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, medidores);
                        binding.spnMedidores.setAdapter(stringArrayAdapter);
                    }
                }, throwable -> {
                    showDialogErroInterno();
                    LoggerUtils.error(throwable, this.getClass().getSimpleName());
                }, this::hideLoading)
        );
    }

    private void sincronizeTipoStatus() {
        ChamadoModel chamadoModel = getCurrentChamadoAtendimento().getChamadoModel();
        ChamadoStatus chamadoStatus = StringUtils.equals(selectedItemText, StatusChamado.CONCLUIDOS.getStatus()) ? ChamadoStatus.O : ChamadoStatus.P;

        mCompositeDisposable.add(mTipoStatusService.list(chamadoStatus.name(), chamadoModel.getEmpresaId())
                .observeOn(mSchedulerProvider.ui())
                .subscribeOn(mSchedulerProvider.io())
                .doOnSubscribe(d -> showLoading())
                .subscribe(result -> {
                    List<TipoStatusResponseDTO> data = result.getData();
                    LoggerUtils.info("" + data);
                    if (CollectionUtils.isNotEmpty(data)) {
                        List<TipoStatusResponseDTO> tipos = new ArrayList<>();
                        tipos.add(new TipoStatusResponseDTO("Selecione um Status", "-1"));
                        tipos.addAll(data);
                        ArrayAdapter<TipoStatusResponseDTO> stringArrayAdapter = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, tipos);
                        binding.spnTipoStatus.setAdapter(stringArrayAdapter);
                    }
                }, throwable -> {
                    showDialogErroInterno();
                    LoggerUtils.error(throwable, this.getClass().getSimpleName());
                }, this::hideLoading)
        );
    }

    @Override
    public void openMainActivity() {
        if (binding.spnTipoStatus.getSelectedItemPosition() == 0) {
            toastyNormal("Tipo do status deve ser informado");
            return;
        }

        if (TextUtils.isEmpty(binding.etFollowUp.getText())) {
            toastyNormal("Follow-up do Técnico não pode ficar em branco");
            return;
        }

        if (TextUtils.isEmpty(binding.etSintoma.getText())) {
            toastyNormal("Sintoma deve ser informado");
            return;
        }

        if (TextUtils.isEmpty(binding.etCausa.getText())) {
            toastyNormal("Causa deve ser informada");
            return;
        }

        if (TextUtils.isEmpty(binding.etAcao.getText())) {
            toastyNormal("Ação deve ser informada");
            return;
        }


        Intent startIntent = openActivity(FinalizarChamadoActivity.this, AssinaturaActivity.class);
        updateAtendimento();
        startActivity(startIntent);
        finish();
    }

    private void updateAtendimento() {
        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
        AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
        ChamadoModel chamadoModel = currentChamadoAtendimento.getChamadoModel();

        boolean isStatusConcluido = StringUtils.equals(selectedItemText, StatusChamado.CONCLUIDOS.getStatus());
        currentChamadoAtendimento.setStatusFinalChamado(isStatusConcluido ? StatusChamado.CONCLUIDOS : StatusChamado.PENDENTE);

        if (!TextUtils.isEmpty(binding.etAcao.getText()))
            atendimentoModel.setAcao(binding.etAcao.getText().toString());

        if (!TextUtils.isEmpty(binding.etFollowUp.getText()))
            chamadoModel.setFollowUpTecnico(binding.etFollowUp.getText().toString());

        if (!TextUtils.isEmpty(binding.etCausa.getText()))
            atendimentoModel.setCausa(binding.etCausa.getText().toString());

        if (!TextUtils.isEmpty(binding.etCopiasDescontadas.getText()))
            atendimentoModel.setMedidorDesc(Integer.valueOf(binding.etCopiasDescontadas.getText().toString()));

        if (!TextUtils.isEmpty(binding.etObservacao.getText()))
            atendimentoModel.setObservacao(binding.etObservacao.getText().toString());

        if (!TextUtils.isEmpty(binding.etSintoma.getText()))
            atendimentoModel.setSintoma(binding.etSintoma.getText().toString());

        if (!TextUtils.isEmpty(binding.etValorMedidor.getText()))
            atendimentoModel.setMedidor(Integer.valueOf(binding.etValorMedidor.getText().toString()));

        if (!TextUtils.isEmpty(binding.etKmFinal.getText()))
            atendimentoModel.setKmFinal(Integer.valueOf(binding.etKmFinal.getText().toString()));

        if (!TextUtils.isEmpty(binding.etValorPedagio.getText())) {
            BigDecimal valorPedagio = MoneyTextWatcher.unMask(binding.etValorPedagio.getText().toString());
            atendimentoModel.setValorPedagio(valorPedagio.doubleValue());
        }

        if (!TextUtils.isEmpty(binding.etValorEstacionamento.getText())) {
            BigDecimal valorEstacionamento = MoneyTextWatcher.unMask(binding.etValorEstacionamento.getText().toString());
            atendimentoModel.setValorEstacionamento(valorEstacionamento.doubleValue());
        }

        if (!TextUtils.isEmpty(binding.etOutrosValores.getText())) {
            BigDecimal outrosValores = MoneyTextWatcher.unMask(binding.etOutrosValores.getText().toString());
            atendimentoModel.setValorOutrasDespesas(outrosValores.doubleValue());
        }

        if (binding.spnMedidores.getSelectedItemPosition() > 0) {
            atendimentoModel.setCdMedidor((String) binding.spnMedidores.getSelectedItem());
        }

        chamadoModel.setCdStatus(((TipoStatusResponseDTO) binding.spnTipoStatus.getSelectedItem()).getCdStatus());

        if (!TextUtils.isEmpty(binding.etNomeAssinante.getText())) {
            atendimentoModel.setNomeContato(binding.etNomeAssinante.getText().toString());
        }

        atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
    }

    @Override
    protected void onDestroy() {
        mPresenter.onDetach();
        mCompositeDisposable.dispose();
        super.onDestroy();
    }

}
