package br.com.softilux.softiluxapp.ui.chamado.detalhes;

import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import org.apache.commons.collections4.CollectionUtils;

import javax.inject.Inject;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.utils.ScrollViewUtils;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.databinding.FragmentDetalhesChamadoBinding;
import br.com.softilux.softiluxapp.databinding.TimelineItemRowBinding;
import br.com.softilux.softiluxapp.di.presentation.PresentationComponent;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseFragment;
import br.com.softilux.softiluxapp.ui.chamado.TimeLineChamado;

/**
 * Created by Vinicius on 03,Fevereiro,2019
 */
public class DetalhesChamadoManutencaoFragment extends AbstractBaseFragment implements DetalhesChamadoMvpView {

    @Inject
    DetalhesChamadoMvpPresenter<DetalhesChamadoMvpView> mPresenter;

    FragmentDetalhesChamadoBinding binding;

    public static DetalhesChamadoManutencaoFragment newInstance () {
        return new DetalhesChamadoManutencaoFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_detalhes_chamado, container, false);

        PresentationComponent component = getActivityComponent();
        if (component != null) {
            component.inject(this);
            mPresenter.onAttach(this);
        }
        return binding.getRoot();
    }

    @Override
    protected void setUp(View view) {
        ChamadoModel find = getCurrentChamadoAtendimento().getChamadoModel();
        AtendimentoModel atendimentoModel = getCurrentChamadoAtendimento().getAtendimentoModel();

        getBaseActivity().setSupportActionBar(binding.toolbar);
        if (getBaseActivity().getSupportActionBar() != null) {
            getBaseActivity().getSupportActionBar().setTitle(find.getToolbarTitle());
            getBaseActivity().getSupportActionBar().setSubtitle(atendimentoModel.getToolbarTitle());
        }

        if (CollectionUtils.isNotEmpty(atendimentoModel.getTimelines())) {
            binding.llTimelineContainer.removeAllViews();

            for (TimelineModel timeLineChamado: atendimentoModel.getTimelines()) {
                addNewItemTimeLine(timeLineChamado, false);
            }
        }
        //CurrentChamado currentChamado = CurrentChamado.getInstance();
        //if (currentChamado.atendimentoJaFoiIniciado() && CollectionUtils.isNotEmpty(currentChamado.getCurrentAtendimentoChamado().getAlteracoesChamado())) {
//            List<TimeLineChamado> alteracoesChamado = currentChamado.getCurrentAtendimentoChamado().getAlteracoesChamado();
//            binding.llTimelineContainer.removeAllViews();
//            for (TimeLineChamado timeLineChamado: alteracoesChamado) {
//                addNewItemTimeLine(timeLineChamado, false);
//            }
//        }

        //ChamadosStatic find = currentChamado.getCurrentChamado();

//        binding.map.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                String query = find.getNumeroEnderecoCliente() + " " + find.getEnderecoCliente() + ", " + find.getCidadeCliente() + ", Brasil";
//                Uri gmmIntentUri = Uri.parse("geo:0,0?q=" + query);
//                Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
//                mapIntent.setPackage("com.google.android.apps.maps");
//                startActivity(mapIntent);
//            }
//        });
//
//        if (find != null) {
//            binding.tvNomeTecnico.setText(find.getNomeTecnico());
//            binding.tvDataAberturaChamado.setText(find.getDataHoraAberturaChamado());
//            binding.tvDataPrevisaoAtendimento.setText(find.getDataPrevisaoAtendimento());
//            binding.tvModalidadeChamado.setText(find.getModalidadeChamado());
//            binding.tvTipoChamado.setText(find.getTipoChamado());
//            binding.tvDefeitoMaquina.setText(find.getDefeitoChamado());
//            binding.tvDefeitoCliente.setText(find.getDefeitoRelatadoCliente());
//            binding.tvClienteChamado.setText(find.getIdCliente() + " - " + find.getNomeCliente());
//            binding.tvEnderecoCliente.setText(find.getEnderecoCliente() + " , " + find.getNumeroEnderecoCliente());
//            binding.tvBairroCliente.setText(find.getBairroCliente());
//            binding.tvCepCliente.setText(find.getCepCliente());
//            binding.tvCidadeCliente.setText(find.getCidadeCliente());
//            binding.tvUfCliente.setText(find.getUfCliente());
//            binding.tvContatoCliente.setText(find.getContatoCliente());
//            binding.tvFoneCliente.setText(find.getTelefoneCliente());
//            binding.tvEmailCliente.setText(find.getEmailCliente());
//            binding.tvSerieEquipamento.setText(find.getSerieEquipamento());
//            binding.tvPatrimonioEquipamento.setText(find.getPatrimonioEquipamento());
//            binding.tvModeloEquipamento.setText(find.getModeloEquipamento());
//            binding.tvDepartamentoEquipamento.setText(find.getDepartamentoEquipamento());
//            binding.tvLocalInstalacaoEquipamento.setText(find.getLocalInstalacaoEquipamento());
//        }

        //Preencher chamado
        binding.tvNomeTecnico.setText(find.getNmSuporte());
        binding.tvDataAberturaChamado.setText(find.getDataInclusaoCompletaAsString());
        binding.tvDataPrevisaoAtendimento.setText(find.getDataPrevisaoCompletaAsString());
        binding.tvModalidadeChamado.setText(find.getModalidadeOs() != null ? find.getModalidadeOs().getNome() : "");
        binding.tvTipoChamado.setText(find.getNmOSTp());
        binding.tvDefeitoMaquina.setText(find.getNmDefeito());
        binding.tvDefeitoCliente.setText(find.getObservacaoDefeitoCli());
        binding.tvClienteChamado.setText(find.getClienteCompletoAsString());
        binding.tvEnderecoCliente.setText(find.getEnderecoCompletoAsString());
        binding.tvBairroCliente.setText(find.getBairro());
        binding.tvCepCliente.setText(find.getCep());
        binding.tvCidadeCliente.setText(find.getCidade());
        binding.tvUfCliente.setText(find.getUf());
        binding.tvContatoCliente.setText(find.getContato());
        binding.tvFoneCliente.setText(find.getFone());
        binding.tvEmailCliente.setText(find.getEmail());
        binding.tvSerieEquipamento.setText(find.getSerieEquipamento());
        binding.tvPatrimonioEquipamento.setText(find.getPatrimonio());
        binding.tvModeloEquipamento.setText(find.getModelo());
        binding.tvDepartamentoEquipamento.setText(find.getDepartamento());
        binding.tvLocalInstalacaoEquipamento.setText(find.getLocalInstalacao());

        // Habilita o botão do google maps
        binding.map.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String query = find.getEnderecoGoogleMaps();
                Uri gmmIntentUri = Uri.parse("geo:0,0?q=" + query);
                Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
                mapIntent.setPackage("com.google.android.apps.maps");
                startActivity(mapIntent);
            }
        });

    }

//    public void addNewItemTimeLine(TimeLineChamado timeLineChamado, boolean scrollToLastView) {
//        View inflate1 = getBaseActivity().getLayoutInflater().inflate(R.layout.timeline_item_row, null);
//        TimelineItemRowBinding bind = DataBindingUtil.bind(inflate1);
//        if (bind != null) {
//            bind.tvMotivoTitle.setText(timeLineChamado.getAndamentoChamadoEnum().getStatus());
//            bind.tvMotivoDescription.setText(timeLineChamado.getMotivo());
//            bind.tvHora.setText(DateUtils.formatHHmm.format(timeLineChamado.getDataRegistro()));
//            bind.ivStatusMotivo.setImageResource(timeLineChamado.getAndamentoChamadoEnum().getImage());
//            binding.llTimelineContainer.addView(inflate1, binding.llTimelineContainer.getChildCount());
//            // TODO
//            //Verificar se a logica a baixo nao é a correta
//            //binding.llTimelineContainer.addView(bind.getRoot(), binding.llTimelineContainer.getChildCount());
//            if (scrollToLastView)
//                ScrollViewUtils.scrollToView(binding.svContainerAll, binding.spaceContainerAll2);
//                //binding.svContainerAll.fullScroll(View.FOCUS_DOWN);
//        }
//    }

    public void addNewItemTimeLine(TimelineModel timelineModel, boolean scrollToLastView) {
        View inflate1 = getBaseActivity().getLayoutInflater().inflate(R.layout.timeline_item_row, null);
        TimelineItemRowBinding bind = DataBindingUtil.bind(inflate1);
        if (bind != null && timelineModel.podeSerApresentadoNaListagem()) {
            bind.tvMotivoTitle.setText(timelineModel.getAndamentoSnapshot().getStatus());
            bind.tvMotivoDescription.setText(timelineModel.getMotivo());
            bind.tvHora.setText(DateUtils.formatHHmm.format(timelineModel.getCreateAt()));
            bind.ivStatusMotivo.setImageResource(timelineModel.getAndamentoSnapshot().getImage());
            binding.llTimelineContainer.addView(inflate1, binding.llTimelineContainer.getChildCount());
            // TODO
            //Verificar se a logica a baixo nao é a correta
            //binding.llTimelineContainer.addView(bind.getRoot(), binding.llTimelineContainer.getChildCount());
            if (scrollToLastView) {
                ScrollViewUtils.scrollToView(binding.svContainerAll, binding.spaceContainerAll2);
            }
            //binding.svContainerAll.fullScroll(View.FOCUS_DOWN);
        }
    }

    @Override
    public void onDestroyView() {
        mPresenter.onDetach();
        super.onDestroyView();
    }
}
