package br.com.softilux.softiluxapp.ui.chamado;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by Vinicius on 03,Fevereiro,2019
 */
public class TimeLineChamado {

    private Long id;

    private AndamentoAtendimentoEnum andamentoChamadoEnum;

    private Date dataRegistro;

    private String motivo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AndamentoAtendimentoEnum getAndamentoChamadoEnum() {
        return andamentoChamadoEnum;
    }

    public void setAndamentoChamadoEnum(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        this.andamentoChamadoEnum = andamentoChamadoEnum;
    }

    public Date getDataRegistro() {
        return dataRegistro;
    }

    public void setDataRegistro(Date dataRegistro) {
        this.dataRegistro = dataRegistro;
    }

    public String getMotivo() {
        return motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public static TimeLineChamado newInstance(AtendimentoChamado atendimentoChamado, AndamentoAtendimentoEnum andamento, String motivo) {
        int idNovoTimeline = atendimentoChamado.getAlteracoesChamado().size() + 1;

        TimeLineChamado timeLineChamado = new TimeLineChamado();
        timeLineChamado.setId((long) idNovoTimeline);
        timeLineChamado.setDataRegistro(Calendar.getInstance().getTime());
        timeLineChamado.setAndamentoChamadoEnum(andamento);
        timeLineChamado.setMotivo(motivo);

        return timeLineChamado;
    }
}
