package br.com.softilux.softiluxapp.ui.chamado;

import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;

public class CurrentChamado {

    private static CurrentChamado instance;

    private Long idChamadoAtivo = 0L;

    private ChamadosStatic currentChamado;

    public final Long defaultIdChamadoAtivo = 0L;

    private Long idAtendimentoChamadoAtivo;

    private AtendimentoChamado currentAtendimentoChamado;

    private CurrentChamado() {
        // Not instance
    }

    public static CurrentChamado getInstance() {
        if (instance == null)
            instance = new CurrentChamado();
        return instance;
    }

    public ChamadosStatic getCurrentChamado() {
        if (this.currentChamado == null && existeChamadoAtivo())
            this.currentChamado = ChamadosStatic.pesquisar(getIdChamadoAtivo());
        return currentChamado;
    }

    public Long getIdAtendimentoChamadoAtivo() {
        return idAtendimentoChamadoAtivo;
    }

    public void setIdAtendimentoChamadoAtivo(Long idAtendimentoChamadoAtivo) {
        this.idAtendimentoChamadoAtivo = idAtendimentoChamadoAtivo;
    }

    public AtendimentoChamado getCurrentAtendimentoChamado() {
        return currentAtendimentoChamado;
    }

    public void setCurrentAtendimentoChamado(AtendimentoChamado currentAtendimentoChamado) {
        this.currentAtendimentoChamado = currentAtendimentoChamado;
    }

    public boolean atendimentoJaFoiIniciado() {
        return this.getCurrentAtendimentoChamado().getAndamentoChamadoEnum() != null;
    }

    public boolean chamadoJaFoiIniciado() {
        return this.getCurrentChamado().getStatus() == StatusChamado.ATIVO;
    }

    public void setCurrentChamado(ChamadosStatic currentChamado) {
        this.currentChamado = currentChamado;
    }

    public static void updateChamadoAtivo(Long id) {
        instance.setIdChamadoAtivo(id);
    }

    public void removerChamadoAtivo() {
        this.setIdChamadoAtivo(0L);
        this.setCurrentChamado(null);
    }

    public void removerAtendimentoAtivo() {
        this.setIdAtendimentoChamadoAtivo(0L);
        this.setCurrentAtendimentoChamado(null);
    }

    public Long getIdChamadoAtivo() {
        return idChamadoAtivo;
    }

    public void setIdChamadoAtivo(Long idChamadoAtivo) {
        this.idChamadoAtivo = idChamadoAtivo;
    }

    public boolean existeChamadoAtivo() {
        return this.getIdChamadoAtivo() != null && this.getIdChamadoAtivo() > 0;
    }

    public boolean existeAtendimentoAtivo() {
        return this.getIdAtendimentoChamadoAtivo() != null && this.getIdAtendimentoChamadoAtivo() > 0;
    }

}
