package br.com.softilux.softiluxapp.ui.chamado;

import android.support.annotation.NonNull;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import br.com.softilux.softiluxapp.data.db.model.ChamadoFilterModel;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.core.utils.CommonUtils;

/**
 * Created by Vinicius on 31,Janeiro,2019
 */
public class ChamadosStatic {

    private static Map<Long, ChamadosStatic> CADASTRO = new HashMap<>();

    private Long chamadoNumero;

    private Long chamadoIluxNumero;

    private String dataHoraAberturaChamado;

    private StatusChamado status;

    private StatusChamado statusAnterior;

    private String nomeCliente;

    private String dataPrevisaoAtendimento;

    private String nomeTecnico;

    private String modalidadeChamado;

    private String tipoChamado;

    private String defeitoChamado;

    private String defeitoRelatadoCliente;

    private String idCliente;

    private String enderecoCliente;

    private String numeroEnderecoCliente;

    private String ufCliente;

    private String bairroCliente;

    private String cepCliente;

    private String cidadeCliente;

    private String contatoCliente;

    private String emailCliente;

    private String telefoneCliente;

    private String serieEquipamento;

    private String patrimonioEquipamento;

    private String modeloEquipamento;

    private String departamentoEquipamento;

    private String localInstalacaoEquipamento;

//    private List<TimeLineChamado> alteracoesChamado;

//    private List<SolicitacaoPecaModel> pecasSolicitadas;

//    private List<Uri> fotosEquipamento;

//    private AndamentoAtendimentoEnum andamentoChamadoEnum;
//
//    private long kmInicial;
//
//    private String placaVeiculo;

    //private List<AtendimentoChamado> atendimentos;
    private Map<Long, AtendimentoChamado> atendimentos;

    private ChamadosStatic() {
    }

    public Long getChamadoNumero() {
        return chamadoNumero;
    }

    public void setChamadoNumero(Long chamadoNumero) {
        this.chamadoNumero = chamadoNumero;
    }

    public Long getChamadoIluxNumero() {
        return chamadoIluxNumero;
    }

    public void setChamadoIluxNumero(Long chamadoIluxNumero) {
        this.chamadoIluxNumero = chamadoIluxNumero;
    }

    public String getDataHoraAberturaChamado() {
        return dataHoraAberturaChamado;
    }

    public void setDataHoraAberturaChamado(String dataHoraAberturaChamado) {
        this.dataHoraAberturaChamado = dataHoraAberturaChamado;
    }

    public String getModalidadeChamado() {
        return modalidadeChamado;
    }

    public void setModalidadeChamado(String modalidadeChamado) {
        this.modalidadeChamado = modalidadeChamado;
    }

    public String getNomeCliente() {
        return nomeCliente;
    }

    public void setNomeCliente(String nomeCliente) {
        this.nomeCliente = nomeCliente;
    }

    public String getDataPrevisaoAtendimento() {
        return dataPrevisaoAtendimento;
    }

    public void setDataPrevisaoAtendimento(String dataPrevisaoAtendimento) {
        this.dataPrevisaoAtendimento = dataPrevisaoAtendimento;
    }

    public StatusChamado getStatus() {
        return status;
    }

    public void setStatus(StatusChamado status) {
        this.status = status;
    }

    public StatusChamado getStatusAnterior() {
        return statusAnterior;
    }

    public void setStatusAnterior(StatusChamado statusAnterior) {
        this.statusAnterior = statusAnterior;
    }

    public String getNomeTecnico() {
        return nomeTecnico;
    }

    public void setNomeTecnico(String nomeTecnico) {
        this.nomeTecnico = nomeTecnico;
    }

    public String getTipoChamado() {
        return tipoChamado;
    }

    public void setTipoChamado(String tipoChamado) {
        this.tipoChamado = tipoChamado;
    }

    public String getDefeitoChamado() {
        return defeitoChamado;
    }

    public void setDefeitoChamado(String defeitoChamado) {
        this.defeitoChamado = defeitoChamado;
    }

    public String getDefeitoRelatadoCliente() {
        return defeitoRelatadoCliente;
    }

    public void setDefeitoRelatadoCliente(String defeitoRelatadoCliente) {
        this.defeitoRelatadoCliente = defeitoRelatadoCliente;
    }

    public String getUfCliente() {
        return ufCliente;
    }

    public void setUfCliente(String ufCliente) {
        this.ufCliente = ufCliente;
    }

    public String getIdCliente() {
        return idCliente;
    }

    public void setIdCliente(String idCliente) {
        this.idCliente = idCliente;
    }

    public String getEnderecoCliente() {
        return enderecoCliente;
    }

    public void setEnderecoCliente(String enderecoCliente) {
        this.enderecoCliente = enderecoCliente;
    }

    public String getNumeroEnderecoCliente() {
        return numeroEnderecoCliente;
    }

    public void setNumeroEnderecoCliente(String numeroEnderecoCliente) {
        this.numeroEnderecoCliente = numeroEnderecoCliente;
    }

    public String getCepCliente() {
        return cepCliente;
    }

    public void setCepCliente(String cepCliente) {
        this.cepCliente = cepCliente;
    }

    public String getBairroCliente() {
        return bairroCliente;
    }

    public void setBairroCliente(String bairroCliente) {
        this.bairroCliente = bairroCliente;
    }

    public String getCidadeCliente() {
        return cidadeCliente;
    }

    public String getTelefoneCliente() {
        return telefoneCliente;
    }

    public void setTelefoneCliente(String telefoneCliente) {
        this.telefoneCliente = telefoneCliente;
    }

    public void setCidadeCliente(String cidadeCliente) {
        this.cidadeCliente = cidadeCliente;
    }

    public String getContatoCliente() {
        return contatoCliente;
    }

    public void setContatoCliente(String contatoCliente) {
        this.contatoCliente = contatoCliente;
    }

    public String getEmailCliente() {
        return emailCliente;
    }

    public void setEmailCliente(String emailCliente) {
        this.emailCliente = emailCliente;
    }

    public String getSerieEquipamento() {
        return serieEquipamento;
    }

    public void setSerieEquipamento(String serieEquipamento) {
        this.serieEquipamento = serieEquipamento;
    }

    public String getPatrimonioEquipamento() {
        return patrimonioEquipamento;
    }

    public void setPatrimonioEquipamento(String patrimonioEquipamento) {
        this.patrimonioEquipamento = patrimonioEquipamento;
    }

    public String getModeloEquipamento() {
        return modeloEquipamento;
    }

    public void setModeloEquipamento(String modeloEquipamento) {
        this.modeloEquipamento = modeloEquipamento;
    }

    public String getDepartamentoEquipamento() {
        return departamentoEquipamento;
    }

    public void setDepartamentoEquipamento(String departamentoEquipamento) {
        this.departamentoEquipamento = departamentoEquipamento;
    }

    public String getLocalInstalacaoEquipamento() {
        return localInstalacaoEquipamento;
    }

    public void setLocalInstalacaoEquipamento(String localInstalacaoEquipamento) {
        this.localInstalacaoEquipamento = localInstalacaoEquipamento;
    }

//    public List<TimeLineChamado> getAlteracoesChamado() {
//        if (this.alteracoesChamado == null)
//            this.alteracoesChamado = new ArrayList<>();
//        return alteracoesChamado;
//    }
//
//    public void setAlteracoesChamado(List<TimeLineChamado> alteracoesChamado) {
//        this.alteracoesChamado = alteracoesChamado;
//    }
//
//    public AndamentoAtendimentoEnum getAndamentoChamadoEnum() {
//        return andamentoChamadoEnum;
//    }
//
//    public void setAndamentoChamadoEnum(AndamentoAtendimentoEnum andamentoChamadoEnum) {
//        this.andamentoChamadoEnum = andamentoChamadoEnum;
//    }
//
//    public List<SolicitacaoPecaModel> getPecasSolicitadas() {
//        if (this.pecasSolicitadas == null)
//            this.pecasSolicitadas = new ArrayList<>();
//        return pecasSolicitadas;
//    }
//
//    public void setPecasSolicitadas(List<SolicitacaoPecaModel> pecasSolicitadas) {
//        this.pecasSolicitadas = pecasSolicitadas;
//    }
//
//    public List<Uri> getFotosEquipamento() {
//        if (this.fotosEquipamento == null)
//            this.fotosEquipamento = new ArrayList<>();
//        return fotosEquipamento;
//    }
//
//    public void setFotosEquipamento(List<Uri> fotosEquipamento) {
//        this.fotosEquipamento = fotosEquipamento;
//    }
//
//    public long getKmInicial() {
//        return kmInicial;
//    }
//
//    public void setKmInicial(long kmInicial) {
//        this.kmInicial = kmInicial;
//    }
//
//    public String getPlacaVeiculo() {
//        return placaVeiculo;
//    }
//
//    public void setPlacaVeiculo(String placaVeiculo) {
//        this.placaVeiculo = placaVeiculo;
//    }

    /*public List<AtendimentoChamado> getAtendimentos() {
        if (this.atendimentos == null)
            this.atendimentos = new ArrayList<>();
        return atendimentos;
    }

    public void setAtendimentos(List<AtendimentoChamado> atendimentos) {
        this.atendimentos = atendimentos;
    }*/

    public Map<Long, AtendimentoChamado> getAtendimentos() {
        if (MapUtils.isEmpty(atendimentos)) {
            atendimentos = new HashMap<>();
        }
        return atendimentos;
    }

    public void setAtendimentos(Map<Long, AtendimentoChamado> atendimentos) {
        this.atendimentos = atendimentos;
    }

    /**
     * Método utilizado para pesquisar um chamado através do login informado
     */
    public static ChamadosStatic pesquisar(Long numeroChamado) {
        init();

        return CADASTRO.get(numeroChamado);
    }

    public static ChamadosStatic pesquisarAtendimento(Long numeroChamado) {
        init();

        return CADASTRO.get(numeroChamado);
    }

    public static List<ChamadosStatic> getAll() {
        init();
        return new ArrayList<>(CADASTRO.values());
    }

    public static void removerChamadoAtivo(Long numeroChamado) {
        ChamadosStatic pesquisar = pesquisar(numeroChamado);
        if (pesquisar != null) {
            removerChamado(numeroChamado);
        }
    }

    private static void removerChamado(Long pesquisar) {
        CADASTRO.remove(pesquisar);
    }

    public static List<ChamadosStatic> getAllByStatus(StatusChamado status) {
        List<ChamadosStatic> chamadosPorStatus = new ArrayList<>();
        for (ChamadosStatic chamadosStatic : getAll()) {
            if (status.equals(chamadosStatic.getStatus())) {
                chamadosPorStatus.add(chamadosStatic);
            }
        }

        return chamadosPorStatus;
    }

    public static int countAllByStatus(StatusChamado status) {
        int count = 0;
        for (ChamadosStatic chamadosStatic : getAll()) {
            if (status.equals(chamadosStatic.getStatus())) {
                count++;
            }
        }

        return count;
    }

    public static boolean containsByStatus(StatusChamado status) {
        boolean containsByStatus = false;

        for (ChamadosStatic chamadosStatic : getAll()) {
            if (status.equals(chamadosStatic.getStatus())) {
                containsByStatus = true;
                break;
            }
        }

        return containsByStatus;
    }



    public static boolean containsByStatusAndFilter(StatusChamado status, ChamadoFilterModel chamadoFilter) {
        boolean containsByStatusAndFilter = false;

        for (ChamadosStatic chamadosStatic : getAll()) {
            if (status.equals(chamadosStatic.getStatus())) {
                if (chamadoFilter != null) {
                    if (chamadoFilter.getNumeroChamadoWeb() != null && chamadoFilter.getNumeroChamadoWeb() > 0
                            && !chamadosStatic.getChamadoNumero().equals(chamadoFilter.getNumeroChamadoWeb()))
                        continue;
                    if (chamadoFilter.getNumeroChamadoSistema() != null && chamadoFilter.getNumeroChamadoSistema() > 0
                            && !chamadosStatic.getChamadoIluxNumero().equals(chamadoFilter.getNumeroChamadoSistema()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getNomeCliente())
                            && !chamadosStatic.getNomeCliente().contains(chamadoFilter.getNomeCliente()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getSerieEquipamento())
                            && !chamadosStatic.getSerieEquipamento().contains(chamadoFilter.getSerieEquipamento()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getStatusChamado())
                            && !chamadosStatic.getStatus().getStatus().equals(chamadoFilter.getStatusChamado()))
                        continue;
                }

                containsByStatusAndFilter = true;
                break;
            }
        }

        return containsByStatusAndFilter;
    }

    public static int countAllByStatusAndFilter(StatusChamado status, ChamadoFilterModel chamadoFilter) {
        int count = 0;
        for (ChamadosStatic chamadosStatic : getAll()) {
            if (status.equals(chamadosStatic.getStatus())) {
                if (chamadoFilter != null) {
                    if (chamadoFilter.getNumeroChamadoWeb() != null && chamadoFilter.getNumeroChamadoWeb() > 0
                            && !chamadosStatic.getChamadoNumero().equals(chamadoFilter.getNumeroChamadoWeb()))
                        continue;
                    if (chamadoFilter.getNumeroChamadoSistema() != null && chamadoFilter.getNumeroChamadoSistema() > 0
                            && !chamadosStatic.getChamadoIluxNumero().equals(chamadoFilter.getNumeroChamadoSistema()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getNomeCliente())
                            && !chamadosStatic.getNomeCliente().contains(chamadoFilter.getNomeCliente()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getSerieEquipamento())
                            && !chamadosStatic.getSerieEquipamento().contains(chamadoFilter.getSerieEquipamento()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getStatusChamado())
                            && !chamadosStatic.getStatus().getStatus().equals(chamadoFilter.getStatusChamado()))
                        continue;
                }

                count++;
            }
        }

        return count;
    }

    public static List<ChamadosStatic> getAllByStatusAndFilter(StatusChamado status, ChamadoFilterModel chamadoFilter) {
        List<ChamadosStatic> chamadosPorStatus = new ArrayList<>();
        for (ChamadosStatic chamadosStatic : getAll()) {
            if (status.equals(chamadosStatic.getStatus())) {
                if (chamadoFilter != null) {
                    if (chamadoFilter.getNumeroChamadoWeb() != null && chamadoFilter.getNumeroChamadoWeb() > 0
                            && !chamadosStatic.getChamadoNumero().equals(chamadoFilter.getNumeroChamadoWeb()))
                        continue;
                    if (chamadoFilter.getNumeroChamadoSistema() != null && chamadoFilter.getNumeroChamadoSistema() > 0
                            && !chamadosStatic.getChamadoIluxNumero().equals(chamadoFilter.getNumeroChamadoSistema()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getNomeCliente())
                            && !chamadosStatic.getNomeCliente().contains(chamadoFilter.getNomeCliente()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getSerieEquipamento())
                            && !chamadosStatic.getSerieEquipamento().contains(chamadoFilter.getSerieEquipamento()))
                        continue;
                    if (StringUtils.isNotBlank(chamadoFilter.getStatusChamado())
                            && !chamadosStatic.getStatus().getStatus().equals(chamadoFilter.getStatusChamado()))
                        continue;
                }

                chamadosPorStatus.add(chamadosStatic);
            }
        }

        return chamadosPorStatus;
    }

    /**
     * Método utilizado para salvar este Chamado
     */
    public void salvar() {
        CADASTRO.put(this.getChamadoNumero(), this);
    }

    public void salvar(AtendimentoChamado atendimentoChamado) {
        atendimentos.put(this.getChamadoNumero(), atendimentoChamado);
    }

    public static List<ChamadoItemRow> createStaticListWithFilter(ChamadoFilterModel chamadoFilter) {
        List<ChamadoItemRow> chamadosHolder = new ArrayList<>();

        if (ChamadosStatic.containsByStatusAndFilter(StatusChamado.ATIVO, chamadoFilter)) {
            ChamadoItemRow chamadoItemRowGroup = createGroup(StatusChamado.ATIVO, chamadoFilter);
            chamadosHolder.add(chamadoItemRowGroup);
            for (ChamadosStatic chamadosStatic : ChamadosStatic.getAllByStatusAndFilter(StatusChamado.ATIVO, chamadoFilter)) {
                ChamadoItemRow newChamado = transformChamadoEmItemRow(chamadosStatic);
                chamadosHolder.add(newChamado);
            }
        }

        if (ChamadosStatic.containsByStatusAndFilter(StatusChamado.ATRASADOS, chamadoFilter)) {
            ChamadoItemRow chamadoItemRowGroup = createGroup(StatusChamado.ATRASADOS, chamadoFilter);
            chamadosHolder.add(chamadoItemRowGroup);
            for (ChamadosStatic chamadosStatic : ChamadosStatic.getAllByStatusAndFilter(StatusChamado.ATRASADOS, chamadoFilter)) {
                ChamadoItemRow newChamado = transformChamadoEmItemRow(chamadosStatic);
                chamadosHolder.add(newChamado);
            }
        }

        if (ChamadosStatic.containsByStatusAndFilter(StatusChamado.PENDENTE, chamadoFilter)
                || ChamadosStatic.containsByStatusAndFilter(StatusChamado.ABERTO, chamadoFilter)) {
            int pendentes = ChamadosStatic.countAllByStatusAndFilter(StatusChamado.PENDENTE, chamadoFilter);
            int abertos = ChamadosStatic.countAllByStatusAndFilter(StatusChamado.ABERTO, chamadoFilter);
            ChamadoItemRow chamadoItemRowGroup = createGroup(StatusChamado.LIBERADO_PARA_ATENDIMENTO, chamadoFilter);
            chamadoItemRowGroup.setGroupCount(pendentes + abertos);
            chamadosHolder.add(chamadoItemRowGroup);
            for (ChamadosStatic chamadosStatic : ChamadosStatic.getAllByStatusAndFilter(StatusChamado.PENDENTE, chamadoFilter)) {
                ChamadoItemRow newChamado = transformChamadoEmItemRow(chamadosStatic);
                chamadosHolder.add(newChamado);
            }
            for (ChamadosStatic chamadosStatic2 : ChamadosStatic.getAllByStatusAndFilter(StatusChamado.ABERTO, chamadoFilter)) {
                ChamadoItemRow newChamado = transformChamadoEmItemRow(chamadosStatic2);
                chamadosHolder.add(newChamado);
            }
        }

        return chamadosHolder;
    }

    private static ChamadoItemRow transformChamadoEmItemRow(ChamadosStatic chamadosStatic) {
        ChamadoItemRow chamadoItemRow = new ChamadoItemRow();

        chamadoItemRow.setChamadoNumero(chamadosStatic.getChamadoNumero());
        chamadoItemRow.setChamadoIluxNumero(chamadosStatic.getChamadoIluxNumero());
        chamadoItemRow.setStatus(chamadosStatic.getStatus());
        chamadoItemRow.setDataPrevisaoAtendimento(chamadosStatic.getDataPrevisaoAtendimento());
        chamadoItemRow.setNomeCliente(chamadosStatic.getIdCliente() + " - " + chamadosStatic.getNomeCliente());
        chamadoItemRow.setColor(chamadosStatic.getStatus().getColor());
        chamadoItemRow.setViewType(CommonUtils.VIEWTYPE_CHAMADO);

        return chamadoItemRow;
    }

    private static ChamadoItemRow createGroup(@NonNull StatusChamado status, ChamadoFilterModel chamadoFilter) {
        ChamadoItemRow chamadoItemRowGroup = new ChamadoItemRow();
        chamadoItemRowGroup.setViewType(CommonUtils.VIEWTYPE_GROUP);
        chamadoItemRowGroup.setGroupName(status.getStatus());
        chamadoItemRowGroup.setColor(status.getColor());
        chamadoItemRowGroup.setGroupCount(ChamadosStatic.countAllByStatusAndFilter(status, chamadoFilter));
        return chamadoItemRowGroup;
    }

    private static void init() {
        if (MapUtils.isEmpty(CADASTRO)) {
            ChamadosStatic chamado = new ChamadosStatic();

            chamado.setChamadoNumero(715964L);
            chamado.setChamadoIluxNumero(231L);
            chamado.setNomeTecnico("TECNICO1");
            chamado.setDataHoraAberturaChamado("09-11-2018 16:38:00");
            chamado.setTipoChamado("ATENDIMENTO WEB");
            chamado.setModalidadeChamado("Assistência/Chamado Técnico ");
            chamado.setDataPrevisaoAtendimento("12/02/2019 06:00");
            chamado.setDefeitoChamado("ATOLAMENTO PAPEL");
            chamado.setDefeitoRelatadoCliente("teäste envio de email");
            chamado.setStatus(StatusChamado.ABERTO);

            chamado.setIdCliente("6");
            chamado.setNomeCliente("JAYOB COMPANY");
            chamado.setEnderecoCliente("RUA DOS MEROS");
            chamado.setNumeroEnderecoCliente("151");
            chamado.setBairroCliente("BALNEÁRIO");
            chamado.setCepCliente("88075301");
            chamado.setCidadeCliente("FLORIANOPOLIS");
            chamado.setUfCliente("SC");
            chamado.setContatoCliente("LUCIANO ");
            chamado.setTelefoneCliente("48 4830281346");
            chamado.setEmailCliente("infosc2007@gmail.com");

            chamado.setSerieEquipamento("PH6001");
            chamado.setPatrimonioEquipamento("SFX001 ");
            chamado.setModeloEquipamento("PAHSER 6000 ");
            chamado.setDepartamentoEquipamento("COMERCIAL ");
            chamado.setLocalInstalacaoEquipamento("");

            CADASTRO.put(chamado.getChamadoNumero(), chamado);

            chamado = new ChamadosStatic();

            chamado.setChamadoNumero(745528L);
            chamado.setChamadoIluxNumero(251L);
            chamado.setNomeTecnico("TECNICO1");
            chamado.setModalidadeChamado("Assistência/Chamado Técnico ");
            chamado.setDataPrevisaoAtendimento("12/02/2019 06:00");
            chamado.setDataHoraAberturaChamado("29-01-2019 16:00:00");
            chamado.setTipoChamado("ATENDIMENTO WEB");
            chamado.setDefeitoChamado("ATOLAMENTO PAPEL");
            chamado.setDefeitoRelatadoCliente("Teste ");
            chamado.setStatus(StatusChamado.ABERTO);

            chamado.setIdCliente("4");
            chamado.setNomeCliente("REVENDA SP - TESTE DE NFE ");
            chamado.setEnderecoCliente("RUA DAS GAROUPAS");
            chamado.setNumeroEnderecoCliente("1000 ");
            chamado.setBairroCliente("MOEMA ");
            chamado.setCepCliente("40190900 ");
            chamado.setCidadeCliente("SAO PAULO");
            chamado.setUfCliente("SP");
            chamado.setContatoCliente("MÁRCIO ");
            chamado.setTelefoneCliente("27 999222286");
            chamado.setEmailCliente("marcio.ribeiro@empresafenix.com.br ");

            chamado.setSerieEquipamento("0");
            chamado.setPatrimonioEquipamento("");
            chamado.setModeloEquipamento("2125 ");
            chamado.setDepartamentoEquipamento("COMERCIAL ");
            chamado.setLocalInstalacaoEquipamento("");

            CADASTRO.put(chamado.getChamadoNumero(), chamado);

            chamado = new ChamadosStatic();

            chamado.setChamadoNumero(689700L);
            chamado.setChamadoIluxNumero(225L);
            chamado.setNomeTecnico("TECNICO1");
            chamado.setDataHoraAberturaChamado("18-10-2018 15:24:00 ");
            chamado.setDataPrevisaoAtendimento("12/02/2019 06:00");
            chamado.setModalidadeChamado("Assistência/Chamado Técnico ");
            chamado.setTipoChamado("ATENDIMENTO WEB");
            chamado.setDefeitoChamado("ATOLAMENTO PAPEL");
            chamado.setDefeitoRelatadoCliente("Teste ");
            chamado.setStatus(StatusChamado.ABERTO);

            chamado.setIdCliente("1");
            chamado.setNomeCliente("SOFTILUX DES MANUT E SUPORTE DE SISTEMAS LTDA ME ");
            chamado.setEnderecoCliente("RUA CORONEL PEDRO DEMORO");
            chamado.setNumeroEnderecoCliente("1595 ");
            chamado.setBairroCliente("BALNEÁRIO");
            chamado.setCepCliente("88075301 ");
            chamado.setCidadeCliente("FLORIANOPOLIS ");
            chamado.setUfCliente("SC");
            chamado.setContatoCliente("LUCIANO ");
            chamado.setTelefoneCliente("48 4830281346 ");
            chamado.setEmailCliente("luciano@softilux.com.br ");

            chamado.setSerieEquipamento("657890 ");
            chamado.setPatrimonioEquipamento("");
            chamado.setModeloEquipamento("CLX-3160FN ");
            chamado.setDepartamentoEquipamento("ADMINISTRATIVO  ");
            chamado.setLocalInstalacaoEquipamento("SALA DE IMPRESSAO ");

            CADASTRO.put(chamado.getChamadoNumero(), chamado);

            chamado = new ChamadosStatic();

            chamado.setChamadoNumero(745092L);
            chamado.setChamadoIluxNumero(248L);
            chamado.setNomeTecnico("TECNICO1");
            chamado.setDataHoraAberturaChamado("18-10-2018 15:24:00 ");
            chamado.setDataPrevisaoAtendimento("12/12/2018 09:00");
            chamado.setModalidadeChamado("Assistência/Chamado Técnico ");
            chamado.setTipoChamado("ATENDIMENTO WEB");
            chamado.setDefeitoChamado("ATOLAMENTO PAPEL");
            chamado.setDefeitoRelatadoCliente("Testando ");
            chamado.setStatus(StatusChamado.ATRASADOS);

            chamado.setIdCliente("4");
            chamado.setNomeCliente(" REVENDA SP - TESTE DE NFE ");
            chamado.setEnderecoCliente("RUA CORONEL PEDRO DEMORO");
            chamado.setNumeroEnderecoCliente("1595 ");
            chamado.setBairroCliente("BALNEÁRIO");
            chamado.setCepCliente("88075301 ");
            chamado.setCidadeCliente("FLORIANOPOLIS ");
            chamado.setUfCliente("SC");
            chamado.setContatoCliente("JOÃO ");
            chamado.setTelefoneCliente("048 39281346 ");
            chamado.setEmailCliente("luciano@softilux.com.br ");

            chamado.setSerieEquipamento("CNQCB25036 ");
            chamado.setPatrimonioEquipamento("");
            chamado.setModeloEquipamento("BROTHER 8080DN ");
            chamado.setDepartamentoEquipamento("ADMINISTRATIVO  ");
            chamado.setLocalInstalacaoEquipamento("SALA DE IMPRESSAO ");

            CADASTRO.put(chamado.getChamadoNumero(), chamado);
        }

    }

    public void updateAtendimento(AtendimentoChamado currentAtendimentoChamado) {
        if (MapUtils.isNotEmpty(this.getAtendimentos()) && atendimentos.get(currentAtendimentoChamado.getId()) != null) {
            atendimentos.put(currentAtendimentoChamado.getId(), currentAtendimentoChamado);
        }
    }
}
