package br.com.softilux.softiluxapp.ui.chamado;

import javax.inject.Inject;

import br.com.softilux.softiluxapp.data.DataManager;
import br.com.softilux.softiluxapp.data.dao.ConfigDAO;
import br.com.softilux.softiluxapp.ui.base.BasePresenter;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

public class ChamadoManutencaoPresenter <V extends ChamadoManutencaoMvpView> extends BasePresenter<V>
        implements ChamadoManutencaoMvpPresenter<V> {

    @Inject
    public ChamadoManutencaoPresenter(DataManager dataManager,
                                      SchedulerProvider schedulerProvider,
                                      CompositeDisposable compositeDisposable,
                                      ConfigDAO configDAO) {
        super(dataManager, schedulerProvider, compositeDisposable,configDAO);
    }

    @Override
    public void saveDadosIniciaisViagem(String kmInicial, String placaVeiculo) {
        AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();

        currentAtendimentoChamado.setKmInicial(Long.valueOf(kmInicial));
        currentAtendimentoChamado.setPlacaVeiculo(placaVeiculo);

        CurrentChamado.getInstance().getCurrentChamado().updateAtendimento(currentAtendimentoChamado);

        getMvpView().continueViagem();
    }
}
