package br.com.softilux.softiluxapp.ui.chamado;

import android.annotation.SuppressLint;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.location.Address;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.aurelhubert.ahbottomnavigation.AHBottomNavigation;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationItem;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationViewPager;
import com.blankj.utilcode.util.TimeUtils;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.inject.Inject;

import br.com.softilux.core.utils.DateUtils;
import br.com.softilux.core.utils.LoggerUtils;
import br.com.softilux.core.webservice.ResponseTransfer;
import br.com.softilux.softiluxapp.R;
import br.com.softilux.softiluxapp.data.dao.AtendimentoDAO;
import br.com.softilux.softiluxapp.data.dao.ChamadoDAO;
import br.com.softilux.softiluxapp.data.dao.TimelineDAO;
import br.com.softilux.softiluxapp.data.db.model.AtendimentoModel;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.CurrentChamadoAtendimento;
import br.com.softilux.softiluxapp.data.db.model.LocationCapture;
import br.com.softilux.softiluxapp.data.db.model.TimelineModel;
import br.com.softilux.softiluxapp.data.db.model.TipoInclusaoTimeLine;
import br.com.softilux.softiluxapp.databinding.DialogOpcaoOutrosBinding;
import br.com.softilux.softiluxapp.databinding.DialogPausarChamado2Binding;
import br.com.softilux.softiluxapp.databinding.DialogRegistrarInicioViagemBinding;
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.AtendimentoReiniciadoDTORequest;
import br.com.softilux.softiluxapp.transfer.datatransfer.reiniciaratendimento.AtendimentoReiniciadoDTOResponse;
import br.com.softilux.softiluxapp.transfer.services.IAtendimentoService;
import br.com.softilux.softiluxapp.transfer.datatransfer.CadastrarNovaTimelineNetworkingRequest;
import br.com.softilux.softiluxapp.transfer.services.ITimelineService;
import br.com.softilux.softiluxapp.transfer.services.TimelineRequestResponse;
import br.com.softilux.softiluxapp.ui.base.AbstractBaseActivity;
import br.com.softilux.softiluxapp.ui.chamado.detalhes.DetalhesChamadoManutencaoFragment;
import br.com.softilux.softiluxapp.ui.chamado.finalizar.FinalizarChamadoActivity;
import br.com.softilux.softiluxapp.ui.chamado.pausar.OffersModel;
import br.com.softilux.softiluxapp.ui.chamado.pausar.OffersRecyclerViewAdapter;
import br.com.softilux.softiluxapp.ui.chamado.pausar.OnMotivoClickListener;
import br.com.softilux.softiluxapp.ui.chamado.pausar.PausarChamadoDialog;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.DadosIniciaisViagemDTO;
import br.com.softilux.core.utils.KeyboardUtils;
import br.com.softilux.softiluxapp.ui.main.MainActivity3;
import br.com.softilux.softiluxapp.utils.rx.SchedulerProvider;
import io.reactivex.disposables.CompositeDisposable;

/**
 * Created by Vinicius on 30,Janeiro,2019
 */
public class ChamadoManutencaoActivityJava extends AbstractBaseActivity implements ChamadoManutencaoMvpView,
        AHBottomNavigation.OnTabSelectedListener,
        View.OnClickListener,
        PausarChamadoDialog.EditNameDialogListener {

    @Inject
    ChamadoManutencaoMvpPresenter<ChamadoManutencaoMvpView> mPresenter;

    @Inject
    AtendimentoDAO mAtendimentoDAO;

    @Inject
    TimelineDAO mTimelineDAO;

    @Inject
    ChamadoDAO mChamadoDAO;

    @Inject
    IAtendimentoService mAtendimentoService;

    @Inject
    ITimelineService iTimelineService;

    @Inject
    SchedulerProvider schedulerProvider;

    @Inject
    CompositeDisposable compositeDisposable;

    Fragment currentFragment;

    BottomViewPagerAdapter mBottomViewPagerAdapter;

    List<AHBottomNavigationItem> bottomNavigationItems = new ArrayList<>();

    AHBottomNavigation mAhBottomNavigation;

    AHBottomNavigationViewPager mAhBottomNavigationViewPager;

    LinearLayout mLinearLayoutContainer;

    private static final int FRAGMENT_DETALHES_CHAMADO = 0;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_chamado_manutencao3);
        getActivityComponent().inject(this);
        mPresenter.onAttach(this);
        setUp();
    }

    @Override
    protected void setUp() {
        AHBottomNavigationItem item1 = new AHBottomNavigationItem("Chamado", R.drawable.ic_build_white_24dp);
        //AHBottomNavigationItem item2 = new AHBottomNavigationItem("Solicitações", R.drawable.ic_add_white_24dp);
        AHBottomNavigationItem item3 = new AHBottomNavigationItem("Imagens", R.drawable.ic_camera_alt_white_24dp);
        bottomNavigationItems.add(item1);
        //bottomNavigationItems.add(item2);
        bottomNavigationItems.add(item3);
        //bottomNavigationItems.add(item5)

        mAhBottomNavigation = findViewById(R.id.bottomNavigationView2);
        mAhBottomNavigation.addItems(bottomNavigationItems);
        mAhBottomNavigation.setAccentColor(ContextCompat.getColor(this, R.color.colorPrimary));
        mAhBottomNavigation.setForceTint(true);
        mAhBottomNavigation.setTitleState(AHBottomNavigation.TitleState.ALWAYS_SHOW);
        mAhBottomNavigation.setOnTabSelectedListener(this);

        mBottomViewPagerAdapter = new BottomViewPagerAdapter(getSupportFragmentManager());

        mAhBottomNavigationViewPager = findViewById(R.id.layout_container);
        mAhBottomNavigationViewPager.setOffscreenPageLimit(2);
        mAhBottomNavigationViewPager.setAdapter(mBottomViewPagerAdapter);

        currentFragment = mBottomViewPagerAdapter.getCurrentFragment();

        // -- Configure container

        mLinearLayoutContainer = findViewById(R.id.ll_container_checkin);
        configureCheckinStatus();
    }

    private void configureCheckinStatus() {
        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
        if (currentChamadoAtendimento != null) {
            // Verificar status chamado
            View view = getView(currentChamadoAtendimento.getAtendimentoModel().getAndamentoChamadoApp());
            if (view != null)
                mLinearLayoutContainer.addView(view);
        }
    }

    private View getView(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        if (andamentoChamadoEnum == null) {
            View inflate = getLayoutInflater().inflate(R.layout.checkin_inicio_chamado, null);
            inflate.findViewById(R.id.btn_comecar_viagem).setOnClickListener(ChamadoManutencaoActivityJava.this);
            return inflate;
        }

        View inflate = null;

        switch (andamentoChamadoEnum) {
            case INICIO_DO_CHAMADO:
                inflate = getLayoutInflater().inflate(R.layout.checkin_chegada_cliente, null);
                inflate.findViewById(R.id.btn_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                inflate.findViewById(R.id.btn_pausar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case MARCAR_CHEGADA_NO_CLIENTE:
                inflate = getLayoutInflater().inflate(R.layout.checkin_inicio_atendimento, null);
                inflate.findViewById(R.id.btn_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                inflate.findViewById(R.id.btn_pausar_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case MARCAR_INICIO_ATENDIMENTO_CLIENTE:
                inflate = getLayoutInflater().inflate(R.layout.checkin_finalizar_atendimento, null);
                inflate.findViewById(R.id.btn_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                inflate.findViewById(R.id.btn_pausar_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE:
                inflate = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_inicio_atendimento, null);
                inflate.findViewById(R.id.btn_retormar_inicio_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO:
                inflate = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_inicio_atendimento, null);
                inflate.findViewById(R.id.btn_retormar_inicio_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO:
                inflate = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_finalizar_atendimento, null);
                inflate.findViewById(R.id.btn_retormar_finalizar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case CHAMADO_RETOMADO_ANTES_DE_CHEGADA_CLIENTE:
                inflate = getLayoutInflater().inflate(R.layout.checkin_chegada_cliente, null);
                inflate.findViewById(R.id.btn_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                inflate.findViewById(R.id.btn_pausar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);

                break;
            case CHAMADO_RETOMADO_ANTES_DE_INICIAR_ATENDIMENTO:
                inflate = getLayoutInflater().inflate(R.layout.checkin_inicio_atendimento, null);
                inflate.findViewById(R.id.btn_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                inflate.findViewById(R.id.btn_pausar_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
            case CHAMADO_RETOMADO_ANTES_DE_FINALIZAR_ATENDIMENTO:
                inflate = getLayoutInflater().inflate(R.layout.checkin_finalizar_atendimento, null);
                inflate.findViewById(R.id.btn_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                inflate.findViewById(R.id.btn_pausar_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                break;
        }

        return inflate;
    }

    @Override
    public void onClick(View v) {
        // Verificação da internet
        if (!isNetworkConnected()) {
            noNetworkConnetedMessage();
            return;
        }

        switch (v.getId()) {
            case R.id.btn_comecar_viagem:
                confirmComecarViagem();
                break;
            case R.id.btn_chegada_cliente:
                confirmAction(AndamentoAtendimentoEnum.MARCAR_CHEGADA_NO_CLIENTE).show();
                break;
            case R.id.btn_iniciar_atendimento:
                confirmAction(AndamentoAtendimentoEnum.MARCAR_INICIO_ATENDIMENTO_CLIENTE).show();
                break;
            case R.id.btn_pausar_chegada_cliente:
                confirmActionPausa(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE);
                break;
            case R.id.btn_pausar_iniciar_atendimento:
                confirmActionPausa(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO);
                break;
            case R.id.btn_pausar_finalizar_chamado:
                confirmActionPausa(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO);
                break;
            case R.id.btn_retormar_chegada_cliente:
                confirmActionRetormar(AndamentoAtendimentoEnum.CHAMADO_RETOMADO_ANTES_DE_CHEGADA_CLIENTE).show();
                break;
            case R.id.btn_retormar_inicio_atendimento:
                confirmActionRetormar(AndamentoAtendimentoEnum.CHAMADO_RETOMADO_ANTES_DE_INICIAR_ATENDIMENTO).show();
                break;
            case R.id.btn_retormar_finalizar_atendimento:
                confirmActionRetormar(AndamentoAtendimentoEnum.CHAMADO_RETOMADO_ANTES_DE_FINALIZAR_ATENDIMENTO).show();
                break;
            case R.id.btn_finalizar_chamado:
                confirmAction(AndamentoAtendimentoEnum.CHAMADO_FINALIZADO).show();
                break;
        }

    }

    private void confirmComecarViagem() {
        AlertDialog.Builder builder = new AlertDialog.Builder(ChamadoManutencaoActivityJava.this);
        DialogRegistrarInicioViagemBinding binding = DataBindingUtil.bind(getLayoutInflater().inflate(R.layout.dialog_registrar_inicio_viagem, null));

        if (binding != null) {
            builder.setView(binding.getRoot());
            AlertDialog alertDialog = builder.create();
            //binding.etPlacaVeiculo.addTextChangedListener(Mask.insert(Mask.VEICULO_MASK, binding.etPlacaVeiculo));
            //binding.etPlacaVeiculo.addTextChangedListener(TextWatcher2.insert(binding.etPlacaVeiculo));
            binding.btnCancelar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    hideKeyboard(alertDialog);
                    alertDialog.dismiss();
                }
            });
            binding.btnContinuar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    hideKeyboard(alertDialog);
                    boolean noContinue = false;
                    if (TextUtils.isEmpty(binding.etPlacaVeiculo.getText()) ) {
                        toastyNormal("Por favor informe a Placa!");
                        noContinue = true;
                    }
                    if (binding.etPlacaVeiculo.getText().toString().length() < 7 && !noContinue) {
                        toastyNormal( "Placa precisa ter 7 caracteres!");
                        noContinue = true;
                    }
                    if (TextUtils.isEmpty(binding.etKmInicial.getText()) && !noContinue) {
                        toastyNormal( "Por favor informe o Km Inicial!");
                        noContinue = true;
                    }
                    if (!isNetworkConnected()) {
                        noNetworkConnetedMessage();
                        noContinue = true;
                    }
                    if (!noContinue) {
                        alertDialog.dismiss();
                        saveDadosIniciaisViagem(
                                binding.etKmInicial.getText().toString(),
                                binding.etPlacaVeiculo.getText().toString());
                    }
                }
            });
            alertDialog.setOnShowListener(new DialogInterface.OnShowListener() {
                @Override
                public void onShow(DialogInterface dialog) {
                    binding.etPlacaVeiculo.post(new Runnable() {
                        @Override
                        public void run() {
                            KeyboardUtils.showSoftInput(binding.etPlacaVeiculo, ChamadoManutencaoActivityJava.this);
                        }
                    });
                }
            });
            alertDialog.show();
        }
    }

    private void saveDadosIniciaisViagem(String kmInicial, String placaVeiculo) {
        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();

        if (currentChamadoAtendimento != null) {
            AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
            LoggerUtils.info("KM digitado= " + kmInicial);
            atendimentoModel.setKmInicial(Integer.parseInt(kmInicial));
            atendimentoModel.setPlacaVeiculo(placaVeiculo);

            DadosIniciaisViagemDTO dadosIniciaisViagemDTO = new DadosIniciaisViagemDTO();
            dadosIniciaisViagemDTO.setIdAtendimentoPortal(atendimentoModel.getIdAtendimentoPortal());
            dadosIniciaisViagemDTO.setKmInicial(atendimentoModel.getKmInicial());
            LoggerUtils.info("KM request= " +atendimentoModel.getKmInicial().toString());
            dadosIniciaisViagemDTO.setPlacaVeiculo(atendimentoModel.getPlacaVeiculo());

            compositeDisposable.add(mAtendimentoService.salvarDadosIniciaisViagem(dadosIniciaisViagemDTO)
                    .observeOn(schedulerProvider.ui())
                    .subscribeOn(schedulerProvider.io())
                    .subscribe(result -> {
                        if (result.hasData() && result.getData()) {
                            mAtendimentoDAO.update(atendimentoModel);
                            atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
                            continueViagem();
                        } else {
                            showDialogErroInterno();
                        }
                    }, throwable -> {
                        showDialogErroInterno();
                        LoggerUtils.error(throwable, this.getClass().getSimpleName());
                    }));
        }
    }

    public void confirmActionPausa(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ChamadoManutencaoActivityJava.this, R.style.AlertDialogTheme);
        DialogPausarChamado2Binding bindingPausa = DataBindingUtil.bind(getLayoutInflater().inflate(R.layout.dialog_pausar_chamado2, null));
        if (bindingPausa != null) {
            builder.setView(bindingPausa.getRoot());
            AlertDialog currentDialog = builder.create();

            bindingPausa.rvOptions.addItemDecoration(new DividerItemDecoration(this, DividerItemDecoration.VERTICAL));
            bindingPausa.rvOptions.setLayoutManager(new LinearLayoutManager(ChamadoManutencaoActivityJava.this));
            bindingPausa.rvOptions.setAdapter(new OffersRecyclerViewAdapter(OffersModel.getAllMotivos(), this, new OnMotivoClickListener() {
                @Override
                public void onItemClick(OffersModel offersModel) {
                    if (offersModel.getId() == 5L) {
                        //bindingPausa.textAreaInformation.setVisibility(View.VISIBLE);
                        currentDialog.dismiss();
                        createAlertDialogOpcaoOutros(andamentoChamadoEnum);
                    } else {
                        //hideKeyboard(bindingPausa.textAreaInformation);
                        //bindingPausa.textAreaInformation.setVisibility(View.GONE);
                    }
                }
            }));
            bindingPausa.btnPausar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (bindingPausa.rvOptions.getAdapter() instanceof  OffersRecyclerViewAdapter) {
                        currentDialog.dismiss();
                        // Nunca reinicia o chamado por aqui
                        onPausarAction(andamentoChamadoEnum,
                                ((OffersRecyclerViewAdapter) bindingPausa.rvOptions.getAdapter()).getTextOfSelectionItem(),
                                false);
                    }
                }
            });
            bindingPausa.btnCancelar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    currentDialog.dismiss();
                }
            });
            currentDialog.show();
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    private void createAlertDialogOpcaoOutros(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ChamadoManutencaoActivityJava.this, R.style.AlertDialogTheme);
        DialogOpcaoOutrosBinding bindingOpcaoOutros = DataBindingUtil.bind(getLayoutInflater().inflate(R.layout.dialog_opcao_outros, null));
        if (bindingOpcaoOutros != null) {
            // Configurar textarea
            bindingOpcaoOutros.textAreaInformation.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & MotionEvent.ACTION_MASK) {
                        case MotionEvent.ACTION_UP:
                            v.getParent().requestDisallowInterceptTouchEvent(false);
                            break;
                    }
                    return false;
                }
            });
            builder.setView(bindingOpcaoOutros.getRoot());
            AlertDialog dialog = builder.create();
            // Configurar botão positivo
            bindingOpcaoOutros.btnSubmit.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    // Fecha o keyboard caso esteja aberto
                    if (!isNetworkConnected()) {
                        noNetworkConnetedMessage();
                        return;
                    }

                    hideKeyboard(bindingOpcaoOutros.textAreaInformation);

                    if (TextUtils.isEmpty(bindingOpcaoOutros.textAreaInformation.getText()))
                        Toast.makeText(ChamadoManutencaoActivityJava.this, "Por favor informe o motivo da pausa!", Toast.LENGTH_SHORT).show();
                    else {
                        // Fecha o dialog
                        dialog.dismiss();
                        // Se foi informado o motivo, então adiona na timeline
                        String motivo = bindingOpcaoOutros.textAreaInformation.getText().toString();

                        onPausarAction(andamentoChamadoEnum,
                                "Outros..." + motivo,
                                bindingOpcaoOutros.cbReiniciarAtendimento.isChecked());
                    }
                }
            });
            // Configurar botão negativo
            bindingOpcaoOutros.btnLater.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    hideKeyboard(bindingOpcaoOutros.textAreaInformation);
                    dialog.dismiss();
                    confirmActionPausa(andamentoChamadoEnum);
                }
            });
            // So pode reiniciar o chamado se o tecnico ainda não chegou no cliente.
            if (AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE.equals(andamentoChamadoEnum))
                bindingOpcaoOutros.llContainerReiniciar.setVisibility(View.VISIBLE);
            else
                bindingOpcaoOutros.llContainerReiniciar.setVisibility(View.GONE);

            dialog.setOnShowListener(new DialogInterface.OnShowListener() {
                @Override
                public void onShow(DialogInterface dialog) {
                    bindingOpcaoOutros.textAreaInformation.post(new Runnable() {
                        @Override
                        public void run() {
                            KeyboardUtils.showSoftInput(bindingOpcaoOutros.textAreaInformation, ChamadoManutencaoActivityJava.this);
                        }
                    });
                }
            });
            // Mostrar dialog
            dialog.show();
        }
    }

    public AlertDialog confirmActionRetormar(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ChamadoManutencaoActivityJava.this, R.style.AlertDialogTheme);

        builder.setMessage("Você deseja confirmar?");
        builder.setTitle("Retomar chamado");
        builder.setPositiveButton("Sim", getPositiveRetomarAction(andamentoChamadoEnum));
        builder.setNegativeButton("Não", (dialog, which) -> dialog.dismiss());

        return builder.create();
    }

    private DialogInterface.OnClickListener getPositiveRetomarAction(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        DialogInterface.OnClickListener onClickListener = null;
        switch (andamentoChamadoEnum) {
            case CHAMADO_RETOMADO_ANTES_DE_CHEGADA_CLIENTE:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        View inflate = getLayoutInflater().inflate(R.layout.checkin_chegada_cliente, null);
                        inflate.findViewById(R.id.btn_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        inflate.findViewById(R.id.btn_pausar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_RETOMADO_ANTES_DE_CHEGADA_CLIENTE, "", "");
                        updateContainerCardView(inflate);
                    }
                };
                break;
            case CHAMADO_RETOMADO_ANTES_DE_INICIAR_ATENDIMENTO:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        View inflate = getLayoutInflater().inflate(R.layout.checkin_inicio_atendimento, null);
                        inflate.findViewById(R.id.btn_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        inflate.findViewById(R.id.btn_pausar_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_RETOMADO_ANTES_DE_INICIAR_ATENDIMENTO, "", "");
                        updateContainerCardView(inflate);
                    }
                };
                break;
            case CHAMADO_RETOMADO_ANTES_DE_FINALIZAR_ATENDIMENTO:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        View inflate = getLayoutInflater().inflate(R.layout.checkin_finalizar_atendimento, null);
                        inflate.findViewById(R.id.btn_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        inflate.findViewById(R.id.btn_pausar_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_RETOMADO_ANTES_DE_FINALIZAR_ATENDIMENTO, "", "");
                        updateContainerCardView(inflate);
                    }
                };
                break;
        }
        return onClickListener;
    }

    private void onPausarAction(AndamentoAtendimentoEnum andamentoChamadoEnum, String mTextOfSelectionItem, Boolean reiniciarAtendimento) {
        switch (andamentoChamadoEnum) {
            case CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE:
                if (reiniciarAtendimento) {
                    reiniciarAtendimento(mTextOfSelectionItem);
                } else {
                    View retomarChegadaCliente = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_chegada_cliente, null);
                    retomarChegadaCliente.findViewById(R.id.btn_retormar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                    atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE,
                            mTextOfSelectionItem,
                            //bindingPausa.textAreaInformation.getText()!= null? bindingPausa.textAreaInformation.getText().toString() : "");
                            "");
                    updateContainerCardView(retomarChegadaCliente);
                }
                break;
            case CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO:
                View retomarInicioAtendimento = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_inicio_atendimento, null);
                retomarInicioAtendimento.findViewById(R.id.btn_retormar_inicio_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO,
                        mTextOfSelectionItem,
                        //bindingPausa.textAreaInformation.getText()!= null? bindingPausa.textAreaInformation.getText().toString() : "");
                        "");
                updateContainerCardView(retomarInicioAtendimento);
                break;
            case CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO:
                View retomarFinalizarAtendimento = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_finalizar_atendimento, null);
                retomarFinalizarAtendimento.findViewById(R.id.btn_retormar_finalizar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO,
                        mTextOfSelectionItem,
                        //bindingPausa.textAreaInformation.getText()!= null? bindingPausa.textAreaInformation.getText().toString() : "");
                        "");
                updateContainerCardView(retomarFinalizarAtendimento);
                break;
        }
    }

    private void reiniciarAtendimento(String motivo) {
        //AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();

        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
        AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
//
//        TimelineModel timelineModel = TimelineModel.reiniciarChamado(atendimentoModel,
//                AndamentoAtendimentoEnum.CHAMADO_REINICIADO,
//                motivo);

        if (checkPermission()) {
            FusedLocationProviderClient locationProviderClient = LocationServices.getFusedLocationProviderClient(ChamadoManutencaoActivityJava.this);
            locationProviderClient.getLastLocation()
                    .addOnSuccessListener(lastLocation -> {

                        CadastrarNovaTimelineNetworkingRequest request = cadastrarNovaTimelineNetworkingRequest(AndamentoAtendimentoEnum.CHAMADO_REINICIADO,
                                motivo, "", atendimentoModel, lastLocation);

                        AtendimentoReiniciadoDTORequest atendimentoReiniciadoDTORequest = new AtendimentoReiniciadoDTORequest(atendimentoModel, request);

                        compositeDisposable.add(mAtendimentoService.reiniciarAtendimento(atendimentoReiniciadoDTORequest)
                                .observeOn(schedulerProvider.ui())
                                .subscribeOn(schedulerProvider.io())
                                .subscribe(
                                        result -> successReiniciarChamado(result, atendimentoReiniciadoDTORequest),
                                        throwable ->  {
                                            LoggerUtils.error(throwable, this.getClass().getSimpleName());
                                            showDialogErroInterno();
                                        }
                                ));
                    }).addOnFailureListener(new OnFailureListener() {
                        @Override
                        public void onFailure(@NonNull Exception e) {
                            LoggerUtils.error(e, this.getClass().getSimpleName());
                            showDialogErroInterno();
                        }
                });
        }

    }

    private void successReiniciarChamado(ResponseTransfer<AtendimentoReiniciadoDTOResponse> result,
                                         AtendimentoReiniciadoDTORequest request) {
        if (result.hasData()) {
            CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
            AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
            ChamadoModel chamadoModel = currentChamadoAtendimento.getChamadoModel();
            AtendimentoReiniciadoDTOResponse data = result.getData();

            TimelineModel timelineModel = TimelineModel.cadastrarNovaTimeline(data, request, atendimentoModel);
            long insert = mTimelineDAO.insert(timelineModel);
            TimelineModel entity = mTimelineDAO.findByIdApp(insert);
            atendimentoModel.getTimelines().add(entity);

            // Altera o status do andamento atual
            atendimentoModel.setAndamentoChamadoApp(timelineModel.getAndamentoSnapshot());
            atendimentoModel.setAtivoApp(data.getAtivoApp() != null && "1".equals(data.getAtivoApp()));
            Date nowDate = TimeUtils.getNowDate();
            atendimentoModel.setDtViagemFinal(nowDate);
            atendimentoModel.setHrViagemFinal(nowDate);
            //atualizarCurrentChamadoAtendimento(getCurrentChamadoAtendimento());
            mAtendimentoDAO.update(atendimentoModel);

            // Altera o status do andamento atual
            chamadoModel.setAtivoApp(false);
            chamadoModel.setStatusApp(chamadoModel.getNovoStatusAposReiniciar());
            mChamadoDAO.update(chamadoModel);

            clearCurrentChamadoAtendimento();

            Intent startIntent = openActivity(ChamadoManutencaoActivityJava.this, MainActivity3.class);
            startIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            startActivity(startIntent);
            finish();
            //atualizarTimelineChamado(entity);
        } else {
            // TODO não implementado
        }

//        TimeLineChamado timeLineChamado = TimeLineChamado.newInstance(currentAtendimentoChamado,
//                AndamentoAtendimentoEnum.CHAMADO_REINICIADO,
//                motivo);
//
//        currentAtendimentoChamado.getAlteracoesChamado().add(timeLineChamado);
//        currentAtendimentoChamado.setAndamentoChamadoEnum(AndamentoAtendimentoEnum.CHAMADO_REINICIADO);
//        currentAtendimentoChamado.setDataFinalChamado(Calendar.getInstance().getTime());
//        CurrentChamado.getInstance().getCurrentChamado().updateAtendimento(currentAtendimentoChamado);
//
//        ChamadosStatic currentChamado = CurrentChamado.getInstance().getCurrentChamado();
//        Long idChamadoAtivo = CurrentChamado.getInstance().getIdChamadoAtivo();
//        ChamadosStatic pesquisar = ChamadosStatic.pesquisar(idChamadoAtivo);
//        pesquisar.setStatus(pesquisar.getStatusAnterior());
//        pesquisar.salvar();
//        //AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();
//        pesquisar.updateAtendimento(currentAtendimentoChamado);
//        CurrentChamado.getInstance().removerChamadoAtivo();
//        CurrentChamado.getInstance().removerAtendimentoAtivo();

    }

    private DialogInterface.OnClickListener getPositiveActionPausa(AndamentoAtendimentoEnum andamentoChamadoEnum, DialogPausarChamado2Binding bindingPausa) {
        DialogInterface.OnClickListener onClickListener = null;
        switch (andamentoChamadoEnum) {
            case CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (bindingPausa.rvOptions.getAdapter() instanceof OffersRecyclerViewAdapter) {
                            View inflate = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_chegada_cliente, null);
                            inflate.findViewById(R.id.btn_retormar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                            atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_CHEGAR_NO_CLIENTE,
                                    ((OffersRecyclerViewAdapter) bindingPausa.rvOptions.getAdapter()).getTextOfSelectionItem(),
                                    //bindingPausa.textAreaInformation.getText()!= null? bindingPausa.textAreaInformation.getText().toString() : "");
                                    "");
                            updateContainerCardView(inflate);
                        }
                    }
                };
                break;
            case CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (bindingPausa.rvOptions.getAdapter() instanceof OffersRecyclerViewAdapter) {
                            View inflate = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_inicio_atendimento, null);
                            inflate.findViewById(R.id.btn_retormar_inicio_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                            atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_DE_INICIAR_ATENDIMENTO,
                                    ((OffersRecyclerViewAdapter) bindingPausa.rvOptions.getAdapter()).getTextOfSelectionItem(),
                                    //bindingPausa.textAreaInformation.getText()!= null? bindingPausa.textAreaInformation.getText().toString() : "");
                                    "");
                            updateContainerCardView(inflate);
                        }
                    }
                };
                break;
            case CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (bindingPausa.rvOptions.getAdapter() instanceof OffersRecyclerViewAdapter) {
                            View inflate = getLayoutInflater().inflate(R.layout.checkin_retormar_chamado_finalizar_atendimento, null);
                            inflate.findViewById(R.id.btn_retormar_finalizar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                            atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_PAUSADO_ANTES_DE_FINALIZAR_ATENDIMENTO,
                                    ((OffersRecyclerViewAdapter) bindingPausa.rvOptions.getAdapter()).getTextOfSelectionItem(),
                                    //bindingPausa.textAreaInformation.getText()!= null? bindingPausa.textAreaInformation.getText().toString() : "");
                                    "");
                            updateContainerCardView(inflate);
                        }
                    }
                };
                break;
        }
        return onClickListener;
    }

    private void updateContainerCardView(View inflate) {
        mLinearLayoutContainer.removeAllViewsInLayout();
        mLinearLayoutContainer.addView(inflate);
    }

    private DialogInterface.OnClickListener getPositiveAction(AndamentoAtendimentoEnum confirmarChegaCliente) {
        DialogInterface.OnClickListener onClickListener = null;
        switch (confirmarChegaCliente) {
            case INICIO_DO_CHAMADO:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        View checkinChegadaCliente = getLayoutInflater().inflate(R.layout.checkin_chegada_cliente, null);
                        checkinChegadaCliente.findViewById(R.id.btn_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        checkinChegadaCliente.findViewById(R.id.btn_pausar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.INICIO_DO_CHAMADO, "", "");
                        mLinearLayoutContainer.removeAllViewsInLayout();
                        mLinearLayoutContainer.addView(checkinChegadaCliente);
                    }
                };
                break;
            case MARCAR_CHEGADA_NO_CLIENTE:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        View inflate = getLayoutInflater().inflate(R.layout.checkin_inicio_atendimento, null);
                        inflate.findViewById(R.id.btn_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        inflate.findViewById(R.id.btn_pausar_iniciar_atendimento).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.MARCAR_CHEGADA_NO_CLIENTE, "", "");
                        mLinearLayoutContainer.removeAllViewsInLayout();
                        mLinearLayoutContainer.addView(inflate);
                    }
                };
                break;
            case MARCAR_INICIO_ATENDIMENTO_CLIENTE:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        View inflate = getLayoutInflater().inflate(R.layout.checkin_finalizar_atendimento, null);
                        inflate.findViewById(R.id.btn_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        inflate.findViewById(R.id.btn_pausar_finalizar_chamado).setOnClickListener(ChamadoManutencaoActivityJava.this);
                        atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.MARCAR_INICIO_ATENDIMENTO_CLIENTE, "", "");
                        mLinearLayoutContainer.removeAllViewsInLayout();
                        mLinearLayoutContainer.addView(inflate);
                    }
                };
                break;
            case CHAMADO_FINALIZADO:
                onClickListener = new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        //atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.CHAMADO_FINALIZADO, "", "");
                        //AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();

//                        TimeLineChamado timeLineChamado = TimeLineChamado.newInstance(currentAtendimentoChamado,
//                                AndamentoAtendimentoEnum.CHAMADO_FINALIZADO,
//                                "");
//
//                        currentAtendimentoChamado.getAlteracoesChamado().add(timeLineChamado);
//                        currentAtendimentoChamado.setAndamentoChamadoEnum(AndamentoAtendimentoEnum.CHAMADO_FINALIZADO);
//                        CurrentChamado.getInstance().getCurrentChamado().updateAtendimento(currentAtendimentoChamado);
                        Intent startIntent = FinalizarChamadoActivity.getStartIntent(ChamadoManutencaoActivityJava.this);
                        startActivity(startIntent);
                        finish();
                    }
                };
                break;
        }
        return onClickListener;
    }

    private void atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum andamento, String motivo, String motivoOutros) {
        //AtendimentoChamado currentAtendimentoChamado = CurrentChamado.getInstance().getCurrentAtendimentoChamado();

        LoggerUtils.info(motivo);
        LoggerUtils.info(motivoOutros);

        CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
            AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();

            if (checkPermission()) {
                FusedLocationProviderClient locationProviderClient = LocationServices.getFusedLocationProviderClient(ChamadoManutencaoActivityJava.this);
                locationProviderClient.getLastLocation()
                        .addOnSuccessListener(lastLocation -> {
                            CadastrarNovaTimelineNetworkingRequest request = cadastrarNovaTimelineNetworkingRequest(andamento,
                                    motivo, motivoOutros, atendimentoModel, lastLocation);

                            compositeDisposable.add(iTimelineService.salvarNova(request)
                                    .observeOn(schedulerProvider.ui())
                                    .subscribeOn(schedulerProvider.io())
                                    .subscribe(result -> cadastrarNovaTimeline(result, request),
                                            throwable -> {
                                                showDialogErroInterno();
                                                LoggerUtils.error(throwable, this.getClass().getSimpleName());
                                            }
                                    ));


                        }).addOnFailureListener(new OnFailureListener() {
                            @Override
                            public void onFailure(@NonNull Exception e) {
                                showDialogErroInterno();
                                LoggerUtils.error(e, this.getClass().getSimpleName());
                            }
                });
            }

//        TimeLineChamado timeLineChamado = TimeLineChamado.newInstance(currentAtendimentoChamado,
//                andamento,
//                motivo + " " + motivoOutros);

        //currentAtendimentoChamado.getAlteracoesChamado().add(timeLineChamado);
        //currentAtendimentoChamado.setAndamentoChamadoEnum(andamento);
        //CurrentChamado.getInstance().getCurrentChamado().updateAtendimento(currentAtendimentoChamado);

        //atualizarTimelineChamado();

//        Fragment fragmentDetalhesChamado = mBottomViewPagerAdapter.getItem(FRAGMENT_DETALHES_CHAMADO);
//        if (fragmentDetalhesChamado instanceof DetalhesChamadoManutencaoFragment) {
//            DetalhesChamadoManutencaoFragment detalhes = (DetalhesChamadoManutencaoFragment)fragmentDetalhesChamado;
//            detalhes.addNewItemTimeLine(timeLineChamado, true);
//        }
    }

    @NotNull
    private CadastrarNovaTimelineNetworkingRequest cadastrarNovaTimelineNetworkingRequest(AndamentoAtendimentoEnum andamento, String motivo, String motivoOutros, AtendimentoModel atendimentoModel, Location lastLocation) {
        CadastrarNovaTimelineNetworkingRequest request = new CadastrarNovaTimelineNetworkingRequest();
        // ------------------------------ Preencher dados da nova timeline
        request.setCreateAt(DateUtils.formatYyyyMMddHHmmss(TimeUtils.getNowDate()));
        request.setTipoTimeLine(TipoInclusaoTimeLine.INCLUSAO_PROGRESSO_APP);
        request.setAndamentoSnapshot(andamento);
        request.setMotivo(motivo);
        request.setMotivoOutros(motivoOutros);
        request.setIdTecnico(atendimentoModel.getNomeAtendente());
        request.setIdAtendimentoPortal(atendimentoModel.getIdAtendimentoPortal());
        request.setIdBase(atendimentoModel.getIdBase());

        // ------------------------------ Preencher localizacao
        LocationCapture locationCapture = getLocationCapture(lastLocation);
        LoggerUtils.info(locationCapture.toString());
        request.setAddress(locationCapture.getAddress());
        request.setCountryName(locationCapture.getCountryName());
        request.setLatitute(locationCapture.getLatitute());
        request.setLongitute(locationCapture.getLongitute());
        request.setLocality(locationCapture.getLocality());
        request.setLocationCaptured(locationCapture.getLocationCaptured());
        return request;
    }

    private LocationCapture getLocationCapture(Location lastLocation) {
        LocationCapture locationCapture = null;
        if (lastLocation != null) {
            LoggerUtils.d("Location = " + lastLocation);
            Address address = getAddress(ChamadoManutencaoActivityJava.this,
                    lastLocation.getLatitude(),
                    lastLocation.getLongitude());
            if (address != null) {
                LoggerUtils.d("Addres = " + address);
                locationCapture = new LocationCapture(address);
            }
        } else {
            boolean localizacaoEncontrada = false;
            locationCapture = new LocationCapture(localizacaoEncontrada);
        }
        return locationCapture;
    }

    private void cadastrarNovaTimeline(ResponseTransfer<TimelineRequestResponse> result, CadastrarNovaTimelineNetworkingRequest request) {
        if (result.hasData()) {
            CurrentChamadoAtendimento currentChamadoAtendimento = getCurrentChamadoAtendimento();
            AtendimentoModel atendimentoModel = currentChamadoAtendimento.getAtendimentoModel();
            TimelineModel timelineModel = TimelineModel.cadastrarNovaTimeline(result.getData(), request, atendimentoModel);
            long insert = mTimelineDAO.insert(timelineModel);
            TimelineModel entity = mTimelineDAO.findByIdApp(insert);
            atendimentoModel.getTimelines().add(entity);
            // Altera o status do andamento atual
            atendimentoModel.setAndamentoChamadoApp(timelineModel.getAndamentoSnapshot());
            atualizarCurrentChamadoAtendimento(currentChamadoAtendimento);
            mAtendimentoDAO.update(atendimentoModel);
            atualizarTimelineChamado(entity);
        } else {
            // TODO não implementado
        }
    }

    private void atualizarTimelineChamado(TimelineModel timelineModel) {
        Fragment fragmentDetalhesChamado = mBottomViewPagerAdapter.getItem(FRAGMENT_DETALHES_CHAMADO);
        if (fragmentDetalhesChamado instanceof DetalhesChamadoManutencaoFragment) {
            DetalhesChamadoManutencaoFragment detalhes = (DetalhesChamadoManutencaoFragment) fragmentDetalhesChamado;
            detalhes.addNewItemTimeLine(timelineModel, true);
        }
    }

    public boolean checkPermission() {
        return checkPermissionLocation();
    }

    public AlertDialog confirmAction(AndamentoAtendimentoEnum andamentoChamadoEnum) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ChamadoManutencaoActivityJava.this, R.style.AlertDialogTheme);

        builder.setMessage("Você deseja confirmar?");
        builder.setTitle(andamentoChamadoEnum.getTitle());
        builder.setPositiveButton("Sim", getPositiveAction(andamentoChamadoEnum));
        builder.setNegativeButton("Não", (dialog, which) -> dialog.dismiss());

        return builder.create();
    }

    @Override
    public void onFinishEditDialog(boolean isSuccess, @NotNull String inputText) {
    }

    @Override
    public boolean onTabSelected(int position, boolean wasSelected) {
        if (currentFragment == null) {
            currentFragment = mBottomViewPagerAdapter.getCurrentFragment();
        }
        mAhBottomNavigationViewPager.setCurrentItem(position, false);
        currentFragment = mBottomViewPagerAdapter.getCurrentFragment();
        return true;
    }

    @Override
    public void continueViagem() {
            AtendimentoModel atendimentoModel = getCurrentChamadoAtendimento().getAtendimentoModel();
            View checkinChegadaCliente = getLayoutInflater().inflate(R.layout.checkin_chegada_cliente, null);
            checkinChegadaCliente.findViewById(R.id.btn_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
            checkinChegadaCliente.findViewById(R.id.btn_pausar_chegada_cliente).setOnClickListener(ChamadoManutencaoActivityJava.this);
            atualizarFragmentDetalhesChamado(AndamentoAtendimentoEnum.INICIO_DO_CHAMADO
                    , "Veículo: " + atendimentoModel.getPlacaVeiculo()
                            + "\n\nKm inicial: " + atendimentoModel.getKmInicial()
                    , "");
            updateContainerCardView(checkinChegadaCliente);
    }

    @Override
    protected void onDestroy() {
        mPresenter.onDetach();
        compositeDisposable.clear();
        super.onDestroy();
    }

}
