package br.com.softilux.softiluxapp.ui.chamado;

import android.os.Parcel;
import android.os.Parcelable;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import br.com.softilux.core.utils.CommonUtils;
import br.com.softilux.softiluxapp.data.db.model.ChamadoModel;
import br.com.softilux.softiluxapp.data.db.model.representation.ChamadoStatus;
import br.com.softilux.softiluxapp.data.db.model.representation.StatusChamado;
import br.com.softilux.softiluxapp.transfer.datatransfer.ChamadoResponse;
import io.paperdb.Paper;

public class ChamadoItemRow implements Parcelable {

    private String groupName;

    private int groupCount;

    private int color;

    private Long chamadoNumero;

    private Long chamadoIluxNumero;

    private StatusChamado status;

    private ChamadoStatus statusPortal;

    private String nomeCliente;

    private String dataPrevisaoAtendimento;

    private int viewType;

    private static final Long GROUP_ATIVO = -1L, GROUP_ATRASADOS = -2L, GROUP_LIBERADO_ATENDIMENTO = -3L;

    public ChamadoItemRow() {}

    public ChamadoItemRow(ChamadoModel chamadoResponse) {
        this.chamadoIluxNumero = chamadoResponse.getSeqOS();
        this.chamadoNumero = chamadoResponse.getIdChamadoWeb();
        this.dataPrevisaoAtendimento = chamadoResponse.getDataPrevisao() + " " + chamadoResponse.getHoraPrevisao();
        this.nomeCliente = chamadoResponse.getCdCliente() + " | " +chamadoResponse.getNmCliente();
        this.status = chamadoResponse.getStatusApp();
        this.viewType = CommonUtils.VIEWTYPE_CHAMADO;
        this.statusPortal = chamadoResponse.getStatusPortal();
    }

    public int getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(int groupCount) {
        this.groupCount = groupCount;
    }

    public String getGroupName() {
        return groupName;
    }

    public ChamadoStatus getStatusPortal() {
        return statusPortal;
    }

    public void setStatusPortal(ChamadoStatus statusPortal) {
        this.statusPortal = statusPortal;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public Long getChamadoNumero() {
        return chamadoNumero;
    }

    public void setChamadoNumero(Long chamadoNumero) {
        this.chamadoNumero = chamadoNumero;
    }

    public Long getChamadoIluxNumero() {
        return chamadoIluxNumero;
    }

    public void setChamadoIluxNumero(Long chamadoIluxNumero) {
        this.chamadoIluxNumero = chamadoIluxNumero;
    }

    public String getNomeCliente() {
        return nomeCliente;
    }

    public void setNomeCliente(String nomeCliente) {
        this.nomeCliente = nomeCliente;
    }

    public String getDataPrevisaoAtendimento() {
        return dataPrevisaoAtendimento;
    }

    public void setDataPrevisaoAtendimento(String dataPrevisaoAtendimento) {
        this.dataPrevisaoAtendimento = dataPrevisaoAtendimento;
    }

    public StatusChamado getStatus() {
        return status;
    }

    public void setStatus(StatusChamado status) {
        this.status = status;
    }

    public int getViewType() {
        return viewType;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    public static ChamadoItemRow criarGrupoChamado(StatusChamado status, int count) {
        ChamadoItemRow chamadoItemRowGroup = new ChamadoItemRow();
        chamadoItemRowGroup.setViewType(CommonUtils.VIEWTYPE_GROUP);
        chamadoItemRowGroup.setGroupName(status.getStatus());
        chamadoItemRowGroup.setColor(status.getColor());
        chamadoItemRowGroup.setGroupCount(count);

        switch (status) {
            case ATIVO:
                chamadoItemRowGroup.setChamadoNumero(GROUP_ATIVO);
                break;
            case ATRASADOS:
                chamadoItemRowGroup.setChamadoNumero(GROUP_ATRASADOS);
                break;
            case ABERTO:
            case PENDENTE:
            case DESPACHADO:
            case EM_MANUTENCAO:
            case LIBERADO_PARA_ATENDIMENTO:
                chamadoItemRowGroup.setChamadoNumero(GROUP_LIBERADO_ATENDIMENTO);
                break;
            default:
                chamadoItemRowGroup.setChamadoNumero(GROUP_LIBERADO_ATENDIMENTO);
                break;
        }
        return chamadoItemRowGroup;
    }

    public static List<ChamadoItemRow> converterModelParaItem(List<ChamadoModel> chamados) {
        List<ChamadoItemRow> itens = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(chamados)) {
            chamados.forEach(chamadoModel -> itens.add(new ChamadoItemRow(chamadoModel)));
        }
        return itens;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChamadoItemRow that = (ChamadoItemRow) o;
        return groupCount == that.groupCount &&
                color == that.color &&
                viewType == that.viewType &&
                Objects.equals(groupName, that.groupName) &&
                Objects.equals(chamadoNumero, that.chamadoNumero) &&
                Objects.equals(chamadoIluxNumero, that.chamadoIluxNumero) &&
                status == that.status &&
                Objects.equals(nomeCliente, that.nomeCliente) &&
                Objects.equals(dataPrevisaoAtendimento, that.dataPrevisaoAtendimento);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupName, groupCount, color, chamadoNumero, chamadoIluxNumero, status, nomeCliente, dataPrevisaoAtendimento, viewType);
    }

    protected ChamadoItemRow(Parcel in) {
        groupName = in.readString();
        groupCount = in.readInt();
        color = in.readInt();
        if (in.readByte() == 0) {
            chamadoNumero = null;
        } else {
            chamadoNumero = in.readLong();
        }
        if (in.readByte() == 0) {
            chamadoIluxNumero = null;
        } else {
            chamadoIluxNumero = in.readLong();
        }
        status = StatusChamado.values()[in.readInt()];
        statusPortal = ChamadoStatus.values()[in.readInt()];
        //status = StatusChamado.getEnumFromStatus(in.readString());
        nomeCliente = in.readString();
        dataPrevisaoAtendimento = in.readString();
        viewType = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ChamadoItemRow> CREATOR = new Creator<ChamadoItemRow>() {
        @Override
        public ChamadoItemRow createFromParcel(Parcel in) {
            return new ChamadoItemRow(in);
        }

        @Override
        public ChamadoItemRow[] newArray(int size) {
            return new ChamadoItemRow[size];
        }
    };

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(groupName);
        dest.writeInt(groupCount);
        dest.writeInt(color);
        if (chamadoNumero == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeLong(chamadoNumero);
        }
        if (chamadoIluxNumero == null) {
            dest.writeByte((byte) 0);
        } else {
            dest.writeByte((byte) 1);
            dest.writeLong(chamadoIluxNumero);
        }
        dest.writeInt(status.ordinal());
        dest.writeInt(statusPortal.ordinal());
        //dest.writeString(status.getStatus());
        dest.writeString(nomeCliente);
        dest.writeString(dataPrevisaoAtendimento);
        dest.writeInt(viewType);
    }

    @Override
    public String toString() {
        return "ChamadoItemRow{" +
                "groupName='" + groupName + '\'' +
                ", groupCount=" + groupCount +
                ", color=" + color +
                ", chamadoNumero=" + chamadoNumero +
                ", chamadoIluxNumero=" + chamadoIluxNumero +
                ", status=" + status +
                ", statusPortal=" + statusPortal +
                ", nomeCliente='" + nomeCliente + '\'' +
                ", dataPrevisaoAtendimento='" + dataPrevisaoAtendimento + '\'' +
                ", viewType=" + viewType +
                '}';
    }

    public String getToolbarTitle() {
        return "Chamado "+ getChamadoNumero() + " / " + getChamadoIluxNumero();
    }
}
