package br.com.softilux.softiluxapp.ui.chamado;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.view.ViewGroup;

import java.util.ArrayList;

import br.com.softilux.softiluxapp.ui.chamado.detalhes.DetalhesChamadoManutencaoFragment;
import br.com.softilux.softiluxapp.ui.chamado.imagens.ImagensChamadoFragment;
import br.com.softilux.softiluxapp.ui.chamado.solicitacoes.SolicitacoesPecasFragment;

public class BottomViewPagerAdapter extends FragmentPagerAdapter {

    private ArrayList<Fragment> fragments = new ArrayList<>();
    private Fragment currentFragment;

    public BottomViewPagerAdapter(FragmentManager fm) {
        super(fm);
        fragments.clear();
        fragments.add(DetalhesChamadoManutencaoFragment.newInstance());
        //fragments.add(SolicitacoesPecasFragment.newInstance());
        fragments.add(ImagensChamadoFragment.newInstance());
    }

    public void add(Fragment frag) {
        this.fragments.add(frag);
    }

    @Override
    public Fragment getItem(int position) {
        return fragments.get(position);
    }

    @Override
    public int getCount() {
        return fragments.size();
    }

    @Override
    public void setPrimaryItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (getCurrentFragment() != object) {
            currentFragment = ((Fragment) object);
        }
        super.setPrimaryItem(container, position, object);
    }

    /**
     * Get the current fragment
     */
    public Fragment getCurrentFragment() {
        return currentFragment;
    }
}
